<?php $__env->startSection('title'); ?>
    All Tour Bookings
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">Tour Bookings <span
                                class="text-muted fw-normal ms-2">(<?php echo e($count_bookings); ?>)</span></h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        

                        


                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH bookings -->
            
            <!-- FETCH FEEDBACKS -->
            
            <?php if(session('messagesave')): ?>
                
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messagesave')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            
            <?php if(session('messagedelete')): ?>
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    <?php echo e(session('messagedelete')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                
            <?php endif; ?>

            
            <?php if(session('messageupdate')): ?>
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messageupdate')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            
            <?php if(session('messagerestore')): ?>
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messagerestore')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>




            <div class="table-responsive mb-4">
                <table class="table align-middle datatable dt-responsive table-check nowrap"
                    style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                    <thead>
                        <tr>

                            
                            <th scope="col"> #Id</th>
                            <th scope="col">First Name</th>
                            <th scope="col">Last Name</th>
                            <th scope="col">Tour </th>
                            <th scope="col">Arrival Date</th>
                            <th style="width: 150px; min-width: 80px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php $__empty_1 = true; $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>

                                
                                <td><?php echo e($booking->id); ?></td>

                                <td>
                                    <?php if(!empty($booking->first_name)): ?>
                                        <?php echo e($booking->first_name); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>

                                </td>


                                <td>
                                    <?php if(!empty($booking->last_name)): ?>
                                        <?php echo e($booking->last_name); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>

                                </td>


                                <td>
                                    <?php if(!empty($booking->tour->name)): ?>
                                        <?php echo e($booking->tour->name); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>

                                </td>

                                <td>
                                    <?php if(!empty($booking->arrival_date)): ?>
                                        <?php echo e($booking->arrival_date); ?>

                                    <?php else: ?>
                                        <span>N/A</span>
                                    <?php endif; ?>
                                </td>

                              
                              


                                <td colspan="6">
                                    <div class="row">

                                    
                                            <div class="col-md-4">
                                                <button type="button" class="btn btn-success" data-bs-toggle="modal"
                                                    data-bs-target="#viewbookingDetails<?php echo e($booking->id); ?>"
                                                    data-bs-whatever="@getbootstrap"><i class=" far fa-eye  "></i></button>
                                            </div>
                                        

                                        
                                        
                                            
                                        

                                        <!-- delete  -->

                                        
                                            <div class="col-md-4">
                                                <form action="<?php echo e(route('all_tour_bookings.destroy', $booking->id)); ?>"
                                                    method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <a> <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                                class="fa fa-trash"> </button> </a>

                                                </form>
                                            </div>
                                        


                                    </div>
                                </td>
                            </tr>

                            <!-- VIEW DETAILS MODEL -->
                            <div class="modal fade" id="viewbookingDetails<?php echo e($booking->id); ?>" tabindex="-1"
                                aria-labelledby="viewbookingDetailsLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewbookingDetailsLabel"> Tour Booking
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>



                                        <div class="modal-body">

                                            <p>Tour Category : 
                                                <?php if(!empty($booking->tour->name)): ?>
                                                <?php echo e($booking->tour->name); ?>

                                                <?php else: ?>
                                                <span>N/A</span>
                                                <?php endif; ?>
                                             </p>
                                            <hr>

                                            <p> Arrival Date : 
                                                <?php if(!empty($booking->arrival_date)): ?>
                                                <?php echo e($booking->arrival_date); ?>

                                                <?php else: ?>
                                                <span>N/A</span>
                                                <?php endif; ?>
                                             </p>
                                            <hr>


                                            <p> First Name :
                                                <?php if(!empty($booking->first_name)): ?>
                                                <?php echo e($booking->first_name); ?>

                                                <?php else: ?>
                                                <span>N/A</span>
                                                <?php endif; ?>

                                            </p>
                                            <hr>
                                            <p> Last Name : 
                                                <?php if(!empty($booking->last_name)): ?>
                                                <?php echo e($booking->last_name); ?>

                                                <?php else: ?>
                                                <span>N/A</span>
                                                <?php endif; ?>
                                             </p>
                                            <hr>
                                            <p> Email : 
                                                <?php if(!empty($booking->email)): ?>
                                                <?php echo e($booking->email); ?>

                                                <?php else: ?>
                                                <span>N/A</span>
                                                <?php endif; ?>
                                             </p>
                                            <hr>

                                            <p> Nationality : 
                                                <?php if(!empty($booking->nationality)): ?>
                                                <?php echo e($booking->nationality); ?>

                                                <?php else: ?>
                                                <span>N/A</span>
                                                <?php endif; ?>
                                             </p>
                                            <hr>

                                            <p> Current Address : 
                                                <?php if(!empty($booking->current_address)): ?>
                                                <?php echo e($booking->current_address); ?>

                                                <?php else: ?>
                                                <span>N/A</span>
                                                <?php endif; ?>
                                             </p>
                                            <hr>

                                            <p> Phone Number : 
                                                <?php if(!empty($booking->phone_number)): ?>
                                                <?php echo e($booking->phone_number); ?>

                                                <?php else: ?>
                                                <span>N/A</span>
                                                <?php endif; ?>
                                             </p>
                                            <hr>

                                            <p> Message : 
                                                <?php if(!empty($booking->message)): ?>
                                                <?php echo e($booking->message); ?>

                                                <?php else: ?>
                                                <span>N/A</span>
                                                <?php endif; ?>
                                             </p>

                                          


                                         

                                            
                                           


                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close
                                            </button>

                                            
                                                
                                            

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- END OF VIEW DETAILS MODEL -->



                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <center>
                                <span class="badge bg-soft-danger text-danger"
                                    style="padding:10px;  font-size:20px;">Oops! No tour bookings available!</span>
                            </center>
                        <?php endif; ?>

                    </tbody>
                </table>
                <!-- end table -->
            </div>
            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->


    </div>
    <!-- container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts_backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vagrant/code/relocateug/resources/views/backend/pages_backend/bookings_tours/index.blade.php ENDPATH**/ ?>