<?php $__env->startSection('title'); ?>
    Tour Details - Relocate Uganda
<?php $__env->stopSection(); ?>


<?php $__env->startSection('extra_styles'); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <section class="main-banner-wrap1 main-banner-wrap5"
        data-bg-image="<?php echo e(asset('assets/frontend_assets/img/slider/slider4.jpg')); ?>">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="main-banner-box1 main-banner-box5">
                        <h1 class="item-title wow fadeInUp" data-wow-delay=".4s">Tour Details</h1>
                        <p style="margin-top:-20px;" class="item-para wow fadeInUp text-center text-white "
                            data-wow-delay=".4s">We have the tours <span class="banner-p"> you have been looking for
                                !</span>
                    </div>



                </div>
            </div>
        </div>
    </section>


    <!--=====================================-->
    <!--=   Single Listing     Start        =-->
    <!--=====================================-->

    <section class="single-listing-wrap1">
        <div class="container">
            <?php if(session('messagesave')): ?>
                
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messagesave')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>


            <?php if(session('messagenotours')): ?>
                
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messagenotours')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>


            <div class="single-property">
                <div class="content-wrapper">
                    <div class="property-heading">
                        <div class="row">
                            <div class="col-lg-3 col-md-12">
                                <div class="single-list-cate">
                                    <?php if($tour->slots_available > 0): ?>
                                        <div class="item-categoery">
                                            TOUR AVAILABLE FOR BOOKING
                                        </div>
                                    <?php elseif($tour->slots_available <= 0): ?>
                                        <button type="submit" class="btn btn-danger" disabled>
                                            TOUR UNITS ALL ALREADY BOOKED

                                        </button>
                                        <br>
                                        <span> You cannot book it.</span>
                                    <?php else: ?>
                                        N/A
                                    <?php endif; ?>



                                </div>


                            </div>
                            <div class="col-lg-9 col-md-12">

                                <div class="single-list-price" style="font-size: 23px; ">
                                    <?php if(!empty($tour->tour_single_cost)): ?>
                                        SINGLES : USD <?php echo e($tour->tour_single_cost); ?>

                                    <?php else: ?>
                                        <span> SINGLES PRICE : N/A </span>
                                    <?php endif; ?>

                                    |
                                    <?php if(!empty($tour->tour_single_cost)): ?>
                                        COUPLES : USD <?php echo e($tour->tour_single_cost); ?>

                                    <?php else: ?>
                                        <span> COUPLES PRICE : N/A </span>
                                    <?php endif; ?>

                                    |

                                    <?php if(!empty($tour->slots_available >= 0)): ?>
                                        SLOTS : <?php echo e($tour->slots_available); ?>

                                    <?php elseif($tour->slots_available == 0): ?>
                                        <span>0</span>
                                    <?php else: ?>
                                        <span> N/A </span>
                                    <?php endif; ?>

                                </div>


                            </div>
                        </div>
                        <div class="row align-items-center">
                            <div class="col-lg-8 col-md-12">
                                <div class="single-verified-area">

                                    <div class="item-title">
                                        <h3>
                                            <?php if(!empty($tour->name)): ?>
                                                <?php echo e($tour->name); ?>

                                            <?php else: ?>
                                                <span>N/A </span>
                                            <?php endif; ?>
                                        </h3>
                                    </div>
                                </div>
                                <div class="single-item-address">
                                    <ul>
                                        <li>
                                            <i class="fas fa-map-marker-alt"></i>
                                            <?php if(!empty($tour->destination)): ?>
                                                Destination : <?php echo e($tour->destination); ?>

                                            <?php else: ?>
                                                <span>destination : N/A </span>
                                            <?php endif; ?>
                                        </li>



                                        <li>
                                            <i class="fas fa-calendar"></i>
                                            <?php if(!empty($tour->created_at)): ?>
                                                Added on : <?php echo e($tour->created_at); ?>

                                            <?php else: ?>
                                                <span>Added on : N/A </span>
                                            <?php endif; ?>
                                        </li>

                                        <li>
                                            <i class="fas fa-clock"></i>
                                            <?php if(!empty($tour->tour_category->name)): ?>
                                                Category : <?php echo e($tour->tour_category->name); ?>

                                            <?php else: ?>
                                                <span>Category : N/A</span>
                                            <?php endif; ?>
                                        </li>


                                    </ul>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="row">
                        
                        <div class="col-lg-8">

                            
                            <a href="javascript::void(0)">
                                <img onerror="if (this.src != '<?php echo e(asset('assets/backend_assets/assets/images/nodata/missing.png')); ?>') this.src = '<?php echo e(asset('assets/backend_assets/assets/images/nodata/missing.png')); ?>';"
                                    src="<?php echo e(asset($tour->featured_photo)); ?>" alt="preview"
                                    style=" width:100% !important; object-fit:cover;">
                            </a>
                            <hr>
                            

                            <div class="single-listing-box1">
                                <div class="overview-area listing-area">
                                    <h3 class="item-title">About This tour</h3>
                                    <p>
                                        <?php if(!empty($tour->description)): ?>
                                            <?php echo e($tour->description); ?>

                                        <?php else: ?>
                                            <span>N/A </span>
                                        <?php endif; ?>
                                    </p>

                                </div>

                                
                                <div class="card" style="margin-top:20px;">
                                    <div class="card-header" style="background-color:#0e274c; color:#ffffff;">
                                        <center>Tour Photos Collection</center>
                                    </div>
                                    <div class="card-body">

                                        <div class="row">

                                            
                                            <?php if(!empty($tour->photo_library)): ?>
                                                <?php $__currentLoopData = is_null($tour->photo_library) ? [] : explode(',', $tour->photo_library); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    
                                                    <div class=" col-md-4 col-lg-4 col-xs-12">

                                                        <a href="<?php echo asset($image); ?>">
                                                            <img style="
                                                                height: 300px; 
                                                                background-color:#f1ecec; 
                                                                object-fit:cover;
                                                                max-width:100% !important;
                                                                border:#ffffff 2px solid;
                                                                background-repeat: no-repeat;
                                                                object-position: center center;
                                                                background-size:cover;
                                                                padding:2px; 
                                                                margin:0px;"
                                                                src="<?php echo e(asset($image)); ?>" alt="">
                                                        </a>


                                                    </div>
                                                    
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php else: ?>
                                                <center><span>No Photos Available <span></center>
                                            <?php endif; ?>
                                            


                                        </div>


                                    </div>
                                </div>

                                

                                
                                <div class="overview-area">
                                    <h3 class="item-title">Overview of the Tour</h3>
                                    <div class="gallery-icon-box">
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Start Date</li>
                                                <li class="deep-clr">
                                                    <?php if(!empty($tour->start_date)): ?>
                                                        <?php echo e($tour->start_date); ?>

                                                    <?php else: ?>
                                                        <span>N/A </span>
                                                    <?php endif; ?>
                                                </li>
                                            </ul>
                                        </div>


                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>End Date :</li>
                                                <li class="deep-clr">
                                                    <?php if(!empty($tour->end_date)): ?>
                                                        <?php echo e($tour->end_date); ?>

                                                    <?php else: ?>
                                                        <span>N/A</span>
                                                    <?php endif; ?>
                                                </li>
                                            </ul>
                                        </div>

                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Couples :</li>
                                                <li class="deep-clr">
                                                    <?php if(!empty($tour->tour_couple_cost)): ?>
                                                        <?php echo e($tour->tour_couple_cost); ?> USD
                                                    <?php else: ?>
                                                        <span>N/A</span>
                                                    <?php endif; ?>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="item-icon-box">
                                            <div class="item-icon">
                                                <i class="flaticon-home"></i>
                                            </div>
                                            <ul class="item-number">
                                                <li>Single Cost :</li>
                                                <li class="deep-clr">
                                                    <?php if(!empty($tour->tour_single_cost)): ?>
                                                        <?php echo e($tour->tour_single_cost); ?> USD
                                                    <?php else: ?>
                                                        <span>N/A</span>
                                                    <?php endif; ?>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>


                                </div>

                                

                                <div class="overview-area floor-plan-box">
                                    <h3 class="item-title">Itenary of the tour</h3>
                                    <?php

                                        $tour_itenaries_data = !empty($tour->tour_itenaries)
                                            ? json_decode($tour->tour_itenaries, true)
                                            : [];
                                        $tour_itenaries_data_grouped_by_day = collect($tour_itenaries_data)->groupBy(
                                            'itenary_day_number',
                                        );

                                    ?>

                                    <?php $__currentLoopData = $tour_itenaries_data_grouped_by_day; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dayNumber => $dayItenaries): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div id="accordion" class="accordion">
                                            <div class="card">
                                                <div class="card-header">
                                                    <div class="heading-title collapsed" data-bs-toggle="collapse"
                                                        data-bs-target="#headingtwo<?php echo e($dayNumber); ?>"
                                                        aria-expanded="true" role="button">
                                                        <span>Day <?php echo e($dayNumber); ?></span>

                                                    </div>
                                                </div>


                                                <div id="headingtwo<?php echo e($dayNumber); ?>" class="collapse"
                                                    data-bs-parent="#accordion">
                                                    
                                                    <div class="card-body">

                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <ul class="ameniting-list">
                                                                    <?php $__currentLoopData = $dayItenaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $itenary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <li><i class="fas fa-check-circle"></i>
                                                                            <b>Time </b> :   &nbsp;<?php echo e($itenary['itenary_time']); ?>  &nbsp; &nbsp; | &nbsp; &nbsp;
                                                                            <b>Activity </b>  &nbsp;
                                                                            : <?php echo e($itenary['itenary_description']); ?>

                                                                        </li>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </ul>
                                                            </div>


                                                        </div>


                                                    </div>
                                                    

                                                </div>
                                            </div>



                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </div>

                                

                                

                                <?php
                                    $tour_activities_data = json_decode($tour->tour_activities);
                                ?>

                                <div class="overview-area ameniting-box">
                                    <h3 class="item-title">Tour Includes</h3>
                                    <div class="row">
                                        <?php $__empty_1 = true; $__currentLoopData = $tour_activities_data ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tour_activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <div class="col-lg-6">
                                                <ul class="ameniting-list">
                                                    <li><i class="fas fa-check-circle"></i>
                                                        <?php echo e($tour_activity); ?>

                                                    </li>
                                                </ul>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <span>No tour activities </span>
                                        <?php endif; ?>

                                    </div>
                                </div>
                                <br>


                                

                                <?php
                                    $tour_includes_data = json_decode($tour->tour_includes);
                                ?>

                                <div class="overview-area ameniting-box">
                                    <h3 class="item-title">Tour Includes</h3>
                                    <div class="row">
                                        <?php $__empty_1 = true; $__currentLoopData = $tour_includes_data ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tour_include): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <div class="col-lg-6">
                                                <ul class="ameniting-list">
                                                    <li><i class="fas fa-check-circle"></i>
                                                        <?php echo e($tour_include); ?>

                                                    </li>
                                                </ul>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <span>No tour includes </span>
                                        <?php endif; ?>

                                    </div>
                                </div>
                                <br>

                                

                                <?php
                                    $tour_excludes_data = json_decode($tour->tour_excludes);
                                ?>

                                <div class="overview-area ameniting-box">
                                    <h3 class="item-title">Tour Excludes</h3>
                                    <div class="row">
                                        <?php $__empty_1 = true; $__currentLoopData = $tour_excludes_data ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tour_exclude): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <div class="col-lg-6">
                                                <ul class="ameniting-list">
                                                    <li><i class="fas fa-check-circle"></i>
                                                        <?php echo e($tour_exclude); ?>

                                                    </li>
                                                </ul>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <span>No tour Excludes </span>
                                        <?php endif; ?>

                                    </div>
                                </div>
                                <br>


                                



                                
                                

                                


                                
                                
                                


                            </div>
                        </div>
                        

                        
                        <div class="col-lg-4 widget-break-lg sidebar-widget">

                            


                            <div class="widget widget-contact-box">
                                <h3 class="widget-subtitle">Book this tour</h3>


                                <form action="<?php echo e(route('tour_bookings.store')); ?>" method="POST"
                                    enctype="multipart/form-data" class="contact-box">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="first_name"
                                                placeholder="Your First Name" />

                                            <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"> <?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="last_name"
                                                placeholder="Last Name" />
                                            <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"> <?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="email"
                                                placeholder="E-mail" />
                                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"> <?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="nationality"
                                                placeholder="Enter Your Nationality" />
                                            <?php $__errorArgs = ['nationality'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"> <?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="current_address"
                                                placeholder="Enter Current Address" />
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <input type="text" class="form-control" name="phone_number"
                                                placeholder="Enter Phone Number" />
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <input type="date" class="form-control" name="arrival_date"
                                                placeholder="Enter arrival date" />
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <input type="hidden" class="form-control" name="tour_id"
                                                value=" <?php echo e($tour->id); ?>" placeholder="Enter tour id" />
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <textarea name="message" id="message" class="form-text" placeholder="Message" cols="30" rows="4"></textarea>
                                    </div>


                                    

                                    <?php if($tour->slots_available > 0): ?>
                                        <div class="form-group col-lg-12">
                                            <div class="advanced-button">
                                                <button type="submit" class="item-btn">
                                                    BOOK TOUR NOW <i class="fas fa-envelope"></i>
                                                </button>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <div class="form-group col-lg-12">
                                            <div class="advanced-button">
                                                <center>
                                                    <button type="submit" class="btn btn-danger" disabled>
                                                        ALL tour UNITS BOOKED

                                                    </button>
                                                    <br>
                                                    <span> You cannot book it.</span>
                                                </center>
                                            </div>
                                        </div>
                                    <?php endif; ?>


                            </div>
                            <div class="form-response"></div>
                            </form>

                            


                            
                            <?php if(!empty($tour->video_url)): ?>
                                <h3 class="widget-subtitle">Video tour</h3>
                                <div class="overview-area video-box1">
                                    

                                    <div class="ratio ratio-16x9">

                                        <iframe width="130" height="175" src=" <?php echo e($tour->video_url); ?>"
                                            allowfullscreen="allowfullscreen" mozallowfullscreen="mozallowfullscreen"
                                            msallowfullscreen="msallowfullscreen" oallowfullscreen="oallowfullscreen"
                                            webkitallowfullscreen="webkitallowfullscreen">
                                        </iframe>

                                    </div>

                                </div>
                            <?php else: ?>
                                <center><span>No Property Video Added </span></center>
                            <?php endif; ?>
                            

                            <hr>


                            
                            

                            


                        </div>

                    </div>
                    
                </div>
            </div>
        </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend/layouts_frontend/master_frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vagrant/code/relocateug/resources/views/frontend/pages_frontend/all_tours/show.blade.php ENDPATH**/ ?>