<?php $__env->startSection('title'); ?>
    All Apartments
<?php $__env->stopSection(); ?>


<?php $__env->startSection('extra_styles'); ?>
    <style>
        /* multiple photo upload - environmental activities css */
        .imagePreview {
            width: 100%;
            height: 300px;
            background-position: center center;
            background: url(http://cliquecities.com/assets/no-image-e3699ae23f866f6cbdf8ba2443ee5c4e.jpg);
            background-color: #fff;
            background-size: cover;
            background-repeat: no-repeat;
            1 display: inline-block;
            box-shadow: 0px -3px 6px 2px rgba(0, 0, 0, 0.2);
        }

        .btn-primary {
            display: block;
            border-radius: 0px;
            box-shadow: 0px 4px 6px 2px rgba(0, 0, 0, 0.2);
            margin-top: -5px;
        }

        .imgUp {
            margin-bottom: 15px;
        }

        .del {
            width: 80px;
            height: 40px;
            padding-top: 3px;
            padding-left: 8px;
            padding-right: 8px;
            background-color: #f60909;
            color: #ffffff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        .imgAdd {
            width: 40px;
            height: 40px;
            padding-top: 3px;
            border-radius: 50%;
            background-color: #4bd7ef;
            color: #fff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        .dell {
            width: 40px;
            height: 40px;
            padding-top: 3px;
            border-radius: 50%;
            background-color: #ca078c;
            color: #fff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        /* end of multiple photo upload - environmental activities css */
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">Apartments <span
                                class="text-muted fw-normal ms-2">(<?php echo e($count_apartments); ?>)</span></h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        <div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('apartment-create')): ?>
                                <a href="/admin/apartments/create" class="btn bg-primary text-light"><i
                                        class="bx bx-plus me-1"></i>
                                    Add Apartment</a>
                            <?php endif; ?>
                        </div>

                        <div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('apartment-restore')): ?>
                                <a href="<?php echo e(route('apartments.trashed')); ?>" class="btn bg-danger text-light"><i
                                        class="bx bx-plus me-1"></i>
                                    Trashed Apartments</a>
                            <?php endif; ?>
                        </div>


                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH apartments -->
            
            <!-- FETCH FEEDBACKS -->
            
            <?php if(session('messagesave')): ?>
                
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messagesave')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            
            <?php if(session('messagedelete')): ?>
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    <?php echo e(session('messagedelete')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                
            <?php endif; ?>

            
            <?php if(session('messageupdate')): ?>
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messageupdate')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            
            <?php if(session('messagerestore')): ?>
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    <?php echo e(session('messagerestore')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>



                <div class="row">
                    <div class="col-md-2"></div>
                    <div class="col-md-8">

                        <form action="<?php echo e(route('apartments.update', $apartment->id)); ?>">
                            <div class="row">

                               <div class="col-md-12">
                                   <div class="mb-3">
                                       <label class="form-label"
                                           for="validationCustom01">Apartment/Property
                                           Name</label>
                                       <input type="text" class="form-control"
                                           id="validationCustom01" name="name"
                                           placeholder="Enter apartment name"
                                           value="<?php echo e($apartment->name); ?>">
                                       <div>
                                           <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                               <small class="text-danger"> <?php echo e($message); ?></small>
                                           <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                       </div>
                                   </div>
                               </div>

                               <div class="col-md-12">
                                   <div class="row">
                                       <div class="col-md-6">
                                           <div class="mb-3">
                                               <label class="form-label"
                                                   for="validationCustom01">Address</label>
                                               <input type="text" class="form-control"
                                                   id="validationCustom01" name="address"
                                                   placeholder="Enter  addresss"
                                                   value="<?php echo e($apartment->address); ?>">
                                               <div>
                                                   <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                       <small class="text-danger">
                                                           <?php echo e($message); ?></small>
                                                   <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                               </div>
                                           </div>
                                       </div>

                                       <div class="col-md-6">
                                           <div class="mb-3">
                                               <label class="form-label"
                                                   for="validationCustom01">Apartment
                                                   Category</label>

                                               <select name="apartment_category_id"
                                                   class="form-select">
                                                   <?php $__currentLoopData = $apartment_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $apartment_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                       <option value="<?php echo e($apartment_category->id); ?>"
                                                           <?php if($apartment_category->id == $apartment->apartment_category_id): echo 'selected'; endif; ?>>
                                                           <?php echo e($apartment_category->category_name); ?>

                                                       </option>
                                                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                               </select>

                                               <div>
                                                   <?php $__errorArgs = ['apartment_category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                       <small class="text-danger">
                                                           <?php echo e($message); ?></small>
                                                   <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                               </div>
                                           </div>
                                       </div>



                                   </div>


                               </div>

                               
                               <div class="col-md-12">
                                   <div class="row">
                                       
                                       <div class="col-md-6">
                                           <div class="mb-3">
                                               <label class="form-label"
                                                   for="validationCustom01">Number Of
                                                   Beds</label>
                                               <input type="number" class="form-control"
                                                   id="validationCustom01" name="beds"
                                                   placeholder="Enter  number of beds"
                                                   value="<?php echo e($apartment->beds); ?>">
                                               <div>
                                                   <?php $__errorArgs = ['beds'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                       <small class="text-danger">
                                                           <?php echo e($message); ?></small>
                                                   <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                               </div>
                                           </div>
                                       </div>
                                       
                                       <div class="col-md-6">
                                           <div class="mb-3">
                                               <label class="form-label"
                                                   for="validationCustom01">Area (sqft)</label>
                                               <input type="number" class="form-control"
                                                   id="validationCustom01" name="size"
                                                   placeholder="Enter area in square ft"
                                                   value="<?php echo e($apartment->size); ?>">
                                               <div>
                                                   <?php $__errorArgs = ['size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                       <small class="text-danger">
                                                           <?php echo e($message); ?></small>
                                                   <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                               </div>
                                           </div>
                                       </div>
                                   </div>
                               </div>
                               

                               
                               <div class="col-md-12">
                                   <div class="row">
                                       
                                       <div class="col-md-6">
                                           <div class="mb-3">
                                               <label class="form-label"
                                                   for="validationCustom01">Number Of
                                                   Rooms</label>
                                               <input type="number" class="form-control"
                                                   id="validationCustom01" name="rooms"
                                                   placeholder="Enter number of rooms"
                                                   value="<?php echo e($apartment->rooms); ?>">
                                               <div>
                                                   <?php $__errorArgs = ['rooms'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                       <small class="text-danger">
                                                           <?php echo e($message); ?></small>
                                                   <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                               </div>
                                           </div>
                                       </div>
                                       
                                       <div class="col-md-6">
                                           <div class="mb-3">
                                               <label class="form-label"
                                                   for="validationCustom01">Bathrooms</label>
                                               <input type="number" class="form-control"
                                                   id="validationCustom01" name="bathrooms"
                                                   placeholder="Enter number of bathrooms"
                                                   value="<?php echo e($apartment->bathrooms); ?>">
                                               <div>
                                                   <?php $__errorArgs = ['bathrooms'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                       <small class="text-danger">
                                                           <?php echo e($message); ?></small>
                                                   <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                               </div>
                                           </div>
                                       </div>
                                   </div>
                               </div>
                               

                               <div class="col-md-6">
                                   <div class="mb-3">
                                       <label class="form-label"
                                           for="validationCustom01">City</label>
                                       <input type="text" class="form-control"
                                           id="validationCustom01" name="city"
                                           placeholder="Enter  city"
                                           value="<?php echo e($apartment->city); ?>">
                                       <div>
                                           <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                               <small class="text-danger"> <?php echo e($message); ?></small>
                                           <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                       </div>
                                   </div>
                               </div>

                               
                               <div class="col-md-6">
                                   <div class="mb-3">
                                       <label class="form-label" for="validationCustom01">Units
                                           Available </label>
                                       <input type="text" class="form-control"
                                           id="validationCustom01" name="units_available"
                                           value="<?php echo e($apartment->units_available); ?>">
                                       <div>
                                           <?php $__errorArgs = ['units_available'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                               <small class="text-danger"> <?php echo e($message); ?></small>
                                           <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                       </div>
                                   </div>
                               </div>


                               
                               <div class="col-md-12">
                                   <div class="mb-3">
                                       <div class="card-header  bg-primary" style=" color:#ffffff;">
                                           Select Amenities for this apartment

                                       </div>
                                       <hr>
                                       <div class="row">

                                           <?php $__currentLoopData = $amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amenity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                               <div class="col-md-4">
                                                   <label>
                                                       <input type="checkbox" name="amenities[]"
                                                           value="<?php echo e($amenity->id); ?>"
                                                           
                                                           <?php echo e(in_array($amenity->id, $apartment->amenities->pluck('id')->toArray()) ? 'checked' : ''); ?>>
                                                       <?php echo e($amenity->name); ?>

                                                   </label>
                                               </div>
                                           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                       </div>


                                   </div>
                               </div>

                               <div class="col-md-12">
                                   <div class="mb-3">
                                       <label class="form-label" for="validationCustom01">3D Video
                                           Link
                                           (Youtube)
                                       </label>
                                       <input type="text" class="form-control"
                                           id="validationCustom01" name="property_video_url"
                                           placeholder="Enter video link from youtube"
                                           value="<?php echo e($apartment->property_video_url); ?>">
                                       <div>
                                           <?php $__errorArgs = ['property_video_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                               <small class="text-danger"> <?php echo e($message); ?></small>
                                           <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                       </div>
                                   </div>
                               </div>

                               <div class="col-md-12">
                                   <div class="mb-3">
                                       <label class="form-label" for="validationCustom01">Google Map
                                           Iframe Link (src)</label>
                                       <input type="text" class="form-control"
                                           id="validationCustom01" name="google_map_iframe_url"
                                           value="<?php echo e($apartment->google_map_iframe_url); ?>"
                                           placeholder="Enter Google map iframe Link (src)">
                                       <div>
                                           <?php $__errorArgs = ['google_map_iframe_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                               <small class="text-danger"> <?php echo e($message); ?></small>
                                           <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                       </div>
                                   </div>
                               </div>

                               
                               <div class="col-md-12">
                                   <div class="row">
                                       
                                       <div class="col-md-6">
                                           <div class="mb-3">
                                               <label class="form-label"
                                                   for="validationCustom01">Price / Month (USD)
                                               </label>
                                               <input type="number" class="form-control"
                                                   id="validationCustom01" name="price"
                                                   placeholder="Enter apartment price"
                                                   value="<?php echo e($apartment->price); ?>">
                                               <div>
                                                   <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                       <small class="text-danger">
                                                           <?php echo e($message); ?></small>
                                                   <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                               </div>
                                           </div>
                                       </div>
                                       
                                       <div class="col-md-6">
                                           <div class="mb-3">
                                               <label class="form-label"
                                                   for="validationCustom01">Price Range ( USD
                                                   )</label>

                                               <select name="price_range" class="form-select">
                                                   
                                                   <option value="1000_2000"
                                                       <?php echo e($apartment->price_range == '1000_2000' ? 'selected' : ''); ?>>
                                                       1000 - 2000 USD
                                                   </option>
                                                   <option value="2000_3000"
                                                       <?php echo e($apartment->price_range == '2000_3000' ? 'selected' : ''); ?>>
                                                       2000 - 3000 USD
                                                   </option>
                                                   <option value="3000_4000"
                                                       <?php echo e($apartment->price_range == '3000_4000' ? 'selected' : ''); ?>>
                                                       3000 - 4000 USD
                                                   </option>
                                                   <option value="4000_5000"
                                                       <?php echo e($apartment->price_range == '4000_5000' ? 'selected' : ''); ?>>
                                                       4000 - 5000 USD
                                                   </option>
                                                   <option value="5000_6000"
                                                       <?php echo e($apartment->price_range == '5000_6000' ? 'selected' : ''); ?>>
                                                       5000 - 6000 USD
                                                   </option>
                                                   <option value="6000_7000"
                                                       <?php echo e($apartment->price_range == '6000_7000' ? 'selected' : ''); ?>>
                                                       6000 - 7000 USD
                                                   </option>
                                                   <option value="7000_8000"
                                                       <?php echo e($apartment->price_range == '7000_8000' ? 'selected' : ''); ?>>
                                                       7000 - 8000 USD
                                                   </option>
                                                   <option value="8000_9000"
                                                       <?php echo e($apartment->price_range == '8000_9000' ? 'selected' : ''); ?>>
                                                       8000 - 9000 USD
                                                   </option>
                                                   <option value="9000_10000"
                                                       <?php echo e($apartment->price_range == '9000_10000' ? 'selected' : ''); ?>>
                                                       9000 - 10000 USD
                                                   </option>


                                               </select>

                                               <div>
                                                   <?php $__errorArgs = ['price_range'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                       <small class="text-danger">
                                                           <?php echo e($message); ?></small>
                                                   <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                               </div>
                                           </div>
                                       </div>
                                   </div>
                               </div>
                               



                               
                               <hr>
                               <div class="col-md-12">
                                   <div class="row">
                                       
                                       <div class="col-md-6">
                                           <div class="mb-3">
                                               <label class="form-label"
                                                   for="validationCustom01">Property
                                                   Status</label>
                                               <div class="form-check form-check-inline">
                                                   <div class="form-check form-check-inline">
                                                       <input class="form-check-input"
                                                           name="property_status" type="radio"
                                                           id="property_status" 
                                                           <?php echo e($apartment->property_status == '1' ? 'checked' : ''); ?>

                                                           value="1">
                                                       <label class="form-check-label"
                                                           for="property_status">Active</label>
                                                   </div>
                                                   <div class="form-check form-check-inline">
                                                       <input class="form-check-input"
                                                           name="property_status" type="radio"
                                                           id="property_status" 
                                                           <?php echo e($apartment->property_status == '0' ? 'checked' : ''); ?>

                                                           value="0">
                                                       <label class="form-check-label"
                                                           for="property_status">In
                                                           Active</label>
                                                   </div>
                                                   
                                                   <?php $__errorArgs = ['property_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                       <span
                                                           class="text-danger"><?php echo e($message); ?></span>
                                                   <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                               </div>
                                           </div>
                                       </div>
                                       
                                       <div class="col-md-6">
                                           <div class="mb-3">
                                               <label class="form-label"
                                                   for="validationCustom01">Booking
                                                   Status</label>
                                               <div class="form-check form-check-inline">
                                                   <div class="form-check form-check-inline">
                                                       <input class="form-check-input"
                                                           name="property_booked_status"
                                                           type="radio" id="property_booked_status"
                                                           
                                                           <?php echo e($apartment->property_booked_status == '1' ? 'checked' : ''); ?>

                                                           value="1">
                                                       <label class="form-check-label"
                                                           for="property_booked_status">Available</label>
                                                   </div>
                                                   <div class="form-check form-check-inline">
                                                       <input class="form-check-input"
                                                           name="property_booked_status"
                                                           type="radio" id="property_booked_status"
                                                           
                                                           <?php echo e($apartment->property_booked_status == '0' ? 'checked' : ''); ?>

                                                           value="0">
                                                       <label class="form-check-label"
                                                           for="property_booked_status">Booked</label>
                                                   </div>
                                                   
                                                   <?php $__errorArgs = ['property_booked_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                       <span
                                                           class="text-danger"><?php echo e($message); ?></span>
                                                   <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                               </div>
                                           </div>
                                       </div>
                                   </div>
                                   


                               </div>
                               <hr>
                               


                               
                               <div class="col-md-12">
                                   <div class="row">
                                       
                                       <div class="col-md-12">
                                           <div class="mb-3">
                                               <label class="form-label"
                                                   for="validationCustom01">Balcony </label>
                                               <div class="form-check form-check-inline">
                                                   <div class="form-check form-check-inline">
                                                       <input class="form-check-input" name="balcony"
                                                           type="radio" id="balcony"
                                                           
                                                           <?php echo e($apartment->balcony == '1' ? 'checked' : ''); ?>

                                                           value="1">
                                                       <label class="form-check-label"
                                                           for="balcony">Available</label>
                                                   </div>
                                                   <div class="form-check form-check-inline">
                                                       <input class="form-check-input" name="balcony"
                                                           type="radio" id="balcony"
                                                           
                                                           <?php echo e($apartment->balcony == '0' ? 'checked' : ''); ?>

                                                           value="0">
                                                       <label class="form-check-label"
                                                           for="balcony">Unavailable</label>
                                                   </div>
                                                   
                                                   <?php $__errorArgs = ['balcony'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                       <span
                                                           class="text-danger"><?php echo e($message); ?></span>
                                                   <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                               </div>
                                           </div>
                                       </div>
                                       
                                       <div class="col-md-12">

                                           
                                           <a href="javascript::void(0)">
                                               <img onerror="if (this.src != '<?php echo e(asset('assets/backend_assets/assets/images/nodata/missing.png')); ?>') this.src = '<?php echo e(asset('assets/backend_assets/assets/images/nodata/missing.png')); ?>';"
                                                   src="<?php echo e(asset($apartment->featured_photo)); ?>"
                                                   alt="preview"
                                                   style=" width:100% !important; object-fit:cover;">
                                           </a>

                                           <div class="mb-3">
                                               <label class="form-label"
                                                   for="validationCustom01">Featured Photo</label>
                                               <input type="file" class="form-control"
                                                   name="featured_photo" id="⁠⁠featured_photo"
                                                   placeholder="">
                                               <div>
                                                   <?php $__errorArgs = ['⁠⁠featured_photo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                       <small class="text-danger">
                                                           <?php echo e($message); ?></small>
                                                   <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                               </div>
                                           </div>
                                       </div>
                                   </div>
                                   


                               </div>
                               <hr>
                               


                               

                               <div class="card" style="margin-top:20px; padding-top:10px;">
                                   <div class="card-header bg-primary" style=" color:#ffffff;">
                                       Apartment photos collection

                                   </div>
                                   

                                   
                                   <div class="row">
                                       <?php if(!empty($apartment->photo_library)): ?>
                                           <?php $__currentLoopData = is_null($apartment->photo_library) ? [] : explode(',', $apartment->photo_library); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                               
                                               <div class=" col-md-6 col-sm-6 col-xs-12">

                                                   <a href="<?php echo asset($image); ?>">
                                                       <img style="
                                                   height: 200px; 
                                                   background-color:#ffffff; 
                                                   object-fit:cover;
                                                   width:100% !important;
                                                   border:#ffffff 2px solid;
                                                   background-repeat: no-repeat;
                                                   object-position: center center;
                                                   background-size:cover;
                                                   padding:7px; 
                                                   margin:0px;"
                                                           src="<?php echo e(asset($image)); ?>"
                                                           alt="">
                                                   </a>

                                                   <p>Remove</p>
                                                   
                                                   


                                               </div>

                                               
                                           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                       <?php else: ?>
                                           <center><span>No Photos Available <span></center>
                                       <?php endif; ?>
                                   </div>
                                   

                                   <!-- Display existing images -->
                                   <?php $__currentLoopData = explode(',', $apartment->photo_library); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                       <img src="<?php echo e($image); ?>"
                                           alt="Apartment Image <?php echo e($key); ?>">

                                       <!-- Provide a delete option -->
                                       <form
                                           action="<?php echo e(route('apartment.deleteImage', ['apartmentId' => $apartment->id, 'imageId' => $key])); ?>"
                                           method="post">
                                           <?php echo csrf_field(); ?>
                                           <?php echo method_field('DELETE'); ?>
                                           <button type="submit">Delete</button>
                                       </form>
                                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>




                                   
                                   <div class="card-header bg-primary" style=" color:#ffffff;">
                                       Add more photos to the apartment collection

                                   </div>
                                   


                                   <div class="card-body">



                                       
                                       <?php $__errorArgs = ['photo_library'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                           <span class="text-danger"><?php echo e($message); ?></span>
                                       <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>


                                       

                                       <input type="file" multiple class="form-control"
                                           name="photo_library[]" id="upload_multiple">


                                   </div>
                               </div>

                               

                               

                               <div class="col-md-12">
                                   <div class="mb-3">
                                       <label class="form-label"
                                           for="validationCustom01">Description</label>

                                       <textarea class="form-control" name="description" id="exampleFormControlTextarea5"
                                           placeholder="Describe the apartment" rows="3"><?php echo e($apartment->description); ?></textarea>
                                       <div>
                                           <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                               <small class="text-danger"> <?php echo e($message); ?></small>
                                           <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                       </div>
                                   </div>

                               </div>
                               <button class="btn btn-primary" type="submit">Update
                                   Apartment</button>
                       </form>
                    </div>
                    <div class="col-md-2"></div>
                </div>

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->












    </div>
    <!-- container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_scripts'); ?>
    
    <script type="text/javascript">
        $(".imgAdd").click(function() {
            $(this).closest(".row").find('.imgAdd').before(
                '<div class="col-md-6 imgUp"><div class="imagePreview"></div><label class="btn btn-primary">Upload<input type="file" name="photo_library[]" class="uploadFile img" value="Upload Photo" style="width:0px;height:0px;overflow:hidden;"></label><i class="fa fa-timess del"><span style="color:#ffffff; ">Remove</span></i></div>'
            );
        });
        $(document).on("click", "i.del", function() {
            // 	to remove card
            $(this).parent().remove();
            // to clear image
            // $(this).parent().find('.imagePreview').css("background-image","url('')");
        });
        $(function() {
            $(document).on("change", ".uploadFile", function() {
                var uploadFile = $(this);
                var files = !!this.files ? this.files : [];
                if (!files.length || !window.FileReader)
                    return; // no file selected, or no FileReader support

                if (/^image/.test(files[0].type)) { // only image file
                    var reader = new FileReader(); // instance of the FileReader
                    reader.readAsDataURL(files[0]); // read the local file

                    reader.onloadend = function() { // set image data as background of div
                        //alert(uploadFile.closest(".upimage").find('.imagePreview').length);
                        uploadFile.closest(".imgUp").find('.imagePreview').css("background-image",
                            "url(" + this.result + ")");
                    }
                }

            });
        });
    </script>


    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts_backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vagrant/code/relocateug/resources/views/backend/pages_backend/apartments/show.blade.php ENDPATH**/ ?>