<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/



// FRONTEND


// Route::middleware(['auth', 'role:buyer'])->group(function () {
Route::get('/', 'App\Http\Controllers\FrontEnd\HomeController@homepage')->name('homepage');
// Route::resource('/relocate_apartments', 'App\Http\Controllers\FrontEnd\Apartments\FrontEndApartmentController');
// Route::resource('/bookings', 'App\Http\Controllers\FrontEnd\Bookings\FrontEndBookingController');

// });


Route::group(['middleware' => ['auth'], 'check_role:buyer,Admin,manager'], function () {
  // frontend routes 
  Route::resource('/relocate_apartments', 'App\Http\Controllers\FrontEnd\Apartments\FrontEndApartmentController');
  Route::get('/apartments/search', 'App\Http\Controllers\FrontEnd\Apartments\FrontEndApartmentController@search_apartment')->name('apartments.search');

  // apartment bookings
  Route::resource('/bookings', 'App\Http\Controllers\FrontEnd\Bookings\FrontEndBookingController');

  // tour bookings
  Route::resource('/tour_bookings', 'App\Http\Controllers\FrontEnd\TourBookings\FrontEndTourBookingController');

  // tours 
  Route::resource('/relocate_tours', 'App\Http\Controllers\FrontEnd\Tours\FrontEndTourController');




  // Route::resource('/admin/dashboard', 'App\Http\Controllers\BackEnd\Dashboard\DashboardController');
// BACKEND ROUTES
  // admin group routes with admin prefix
  Route::group(['prefix' => 'admin'], function () {

    // // Admin dashboard
    Route::resource('/dashboard', 'App\Http\Controllers\BackEnd\Dashboard\DashboardController');

    // amenities
    Route::resource('/amenities', 'App\Http\Controllers\BackEnd\Ammenities\AmmentityController');
    Route::get('/trashed_amenities', 'App\Http\Controllers\BackEnd\Ammenities\AmmentityController@trashed_amenities')->name('amenities.trashed');
    Route::post('/trashed_amenities/{id}/restore', 'App\Http\Controllers\BackEnd\Ammenities\AmmentityController@restore_trashed_amenities')->name('amenities.restore');

    // apartment category
    Route::resource('/apartment_categories', 'App\Http\Controllers\BackEnd\ApartmentCategories\ApartmentCategoryController');
    Route::get('/trashed_apartment_categories', 'App\Http\Controllers\BackEnd\ApartmentCategories\ApartmentCategoryController@trashed_apartment_categories')->name('apartment_categories.trashed');
    Route::post('/trashed_apartment_categories/{id}/restore', 'App\Http\Controllers\BackEnd\ApartmentCategories\ApartmentCategoryController@restore_trashed_apartment_categories')->name('apartment_categories.restore');

    // apartments
    Route::resource('/apartments', 'App\Http\Controllers\BackEnd\Apartments\ApartmentController');
    // test ajax submit


    Route::get('/trashed_apartments', 'App\Http\Controllers\BackEnd\Apartments\ApartmentController@trashed_apartments')->name('apartments.trashed');
    Route::post('/trashed_apartments/{id}/restore', 'App\Http\Controllers\BackEnd\Apartments\ApartmentController@restore_trashed_apartments')->name('apartments.restore');
    Route::delete('apartment/{id}/delete-image', 'App\Http\Controllers\BackEnd\Apartments\ApartmentController@delete_apartment_image')->name('apartment.delete_apartment_image');




    // bookings
    Route::get('/bookings', 'App\Http\Controllers\BackEnd\Bookings\BookingController@get_all_booings');
    // delete booking
    Route::delete('/bookings/{id}', 'App\Http\Controllers\BackEnd\Bookings\BookingController@delete_apartment_booking')->name('bookings.destroy');

    // tour bookings
    Route::resource('/all_tour_bookings', 'App\Http\Controllers\BackEnd\TourBookings\TourBookingController');

    // tour categories
    Route::resource('/tour_categories', 'App\Http\Controllers\BackEnd\TourCategories\TourCategoryController');
    Route::get('/trashed_tour_categories', 'App\Http\Controllers\BackEnd\TourCategories\TourCategoryController@trashed_tour_categories')->name('tour_categories.trashed');
    Route::post('/trashed_tour_categories/{id}/restore', 'App\Http\Controllers\BackEnd\TourCategories\TourCategoryController@restore_trashed_tour_categories')->name('tour_categories.restore');


     // tours
     Route::resource('/tours', 'App\Http\Controllers\BackEnd\Tours\TourController');
     Route::get('/trashed_tours', 'App\Http\Controllers\BackEnd\Tours\TourController@trashed_tours')->name('tours.trashed');
     Route::post('/trashed_tours/{id}/restore', 'App\Http\Controllers\BackEnd\Tours\TourController@restore_trashed_tours')->name('tours.restore');
     Route::delete('tour/{id}/delete-image', 'App\Http\Controllers\BackEnd\Tours\TourController@delete_tour_image')->name('tour.delete_tour_image');

    //  itenaries
    Route::delete('/itenaries/{id}', 'App\Http\Controllers\BackEnd\Tours\TourController@delete_itenary')->name('itenaries.destroy');




    // roles and permissions
    Route::resource('roles', App\Http\Controllers\RoleController::class);
    Route::resource('users', App\Http\Controllers\UserController::class);
    Route::resource('products', App\Http\Controllers\ProductController::class);
    Route::resource('permissions', App\Http\Controllers\PermissionController::class);


  });

});



// BACKEND
// admin routes
// Route::group(['middleware' => 'auth',  'role:Admin', 'prefix' => 'admin'], function() {
// // Admin dashboard
// Route::resource('/dashboard', 'App\Http\Controllers\BackEnd\Dashboard\DashboardController');

// // amenities
// Route::resource('/amenities', 'App\Http\Controllers\BackEnd\Ammenities\AmmentityController');
// Route::get('/trashed_amenities', 'App\Http\Controllers\BackEnd\Ammenities\AmmentityController@trashed_amenities')->name('amenities.trashed');
// Route::post('/trashed_amenities/{id}/restore', 'App\Http\Controllers\BackEnd\Ammenities\AmmentityController@restore_trashed_amenities')->name('amenities.restore');

// // apartment category
// Route::resource('/apartment_categories', 'App\Http\Controllers\BackEnd\ApartmentCategories\ApartmentCategoryController');
// Route::get('/trashed_apartment_categories', 'App\Http\Controllers\BackEnd\ApartmentCategories\ApartmentCategoryController@trashed_apartment_categories')->name('apartment_categories.trashed');
// Route::post('/trashed_apartment_categories/{id}/restore', 'App\Http\Controllers\BackEnd\ApartmentCategories\ApartmentCategoryController@restore_trashed_apartment_categories')->name('apartment_categories.restore');

// // apartments
// Route::resource('/apartments', 'App\Http\Controllers\BackEnd\Apartments\ApartmentController');
// Route::get('/trashed_apartments', 'App\Http\Controllers\BackEnd\Apartments\ApartmentController@trashed_apartments')->name('apartments.trashed');
// Route::post('/trashed_apartments/{id}/restore', 'App\Http\Controllers\BackEnd\Apartments\ApartmentController@restore_trashed_apartments')->name('apartments.restore');

// // bookings
// Route::get('/bookings', 'App\Http\Controllers\BackEnd\Bookings\BookingController@get_all_booings');
// // delete booking
// Route::delete('/bookings/{id}', 'App\Http\Controllers\BackEnd\Bookings\BookingController@delete_apartment_booking')->name('bookings.destroy');




// // roles and permissions
// Route::resource('roles', App\Http\Controllers\RoleController::class);
// Route::resource('users', App\Http\Controllers\UserController::class);
// Route::resource('products', App\Http\Controllers\ProductController::class);
// Route::resource('permissions', App\Http\Controllers\PermissionController::class);

// });



// Auth::routes();
Auth::routes([
  'register' => false, // Registration Routes...
  'reset' => false, // Password Reset Routes...
  'verify' => false, // Email Verification Routes...
]);


// Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

// Logout
Route::get('/logout', function () {
  Auth::logout();
  return Redirect::to('login');
});

