<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title> Booking Notification</title>
    <style>
        /* Reset some default styles */
        body,
        h1,
        h2,
        p {
            margin: 0;
            padding: 0;
        }

        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            background-color: #f4f4f4;
            padding: 20px;
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        h1 {
            color: #333333;
            margin-bottom: 20px;
        }

        p {
            color: #555555;
            margin-bottom: 20px;
        }

        .button {
            display: inline-block;
            padding: 10px 20px;
            text-decoration: none;
            background-color: #007bff;
            color: #ffffff;
            border-radius: 5px;
        }
    </style>
</head>

<body>
    <div class="container">

        <h2>Hi, Relocate Portal #Administrator</h2>
        <hr> <br>

        <p><b>New Apartment Booking! Find details below. </b></p>



        <p>Apartment :
            {{ $booking_data['apartment']['name'] }}
        </p>
        <p>First Name :
            @if (!empty($booking_data['first_name']))
                {{ $booking_data['first_name'] }}
            @else
                <span> N/A </span>
            @endif


        </p>
        <p>Last Name :

            @if (!empty($booking_data['last_name']))
                {{ $booking_data['last_name'] }}
            @else
                <span> N/A </span>
            @endif

        </p>

        <p>Email :
            @if (!empty($booking_data['email']))
                {{ $booking_data['email'] }}
            @else
                <span> N/A </span>
            @endif
        </p>


        <p>Nationality :

            @if (!empty($booking_data['nationality']))
                {{ $booking_data['nationality'] }}
            @else
                <span> N/A </span>
            @endif
        </p>

        <p>Phone Number :

            @if (!empty($booking_data['phone_number']))
                {{ $booking_data['phone_number'] }}
            @else
                <span> N/A </span>
            @endif

        </p>
        <p>Arrival Date :

            @if (!empty($booking_data['arrival_date']))
                {{ $booking_data['arrival_date'] }}
            @else
                <span> N/A </span>
            @endif

        </p>

        <p style="max-width: 100%; word-wrap: break-word;"> Message <br>

            @if (!empty($booking_data['message']))
                {{ $booking_data['message'] }}
            @else
                <span> N/A </span>
            @endif
        </p>

        <hr>
        {{-- <a href="#" class="button">Click Me</a> --}}
        <p>Thank you for your noting down these details.</p>
        <p>It will be helpful if you give me response soon</p>
        <p>Best regards,<br>
            @if (!empty($booking_data['first_name']))
                {{ $booking_data['first_name'] }}
            @else
                <span> N/A </span>
            @endif

            @if (!empty($booking_data['last_name']))
                {{ $booking_data['last_name'] }}
            @else
                <span> N/A </span>
            @endif

        </p>
    </div>
</body>

</html>
