{{-- @extends('layouts.app') --}}
@extends('backend.layouts_backend.master')

@section('title')
    Show user
@endsection
@section('content')


    <!-- Main content dashboard  -->
    <div class="page-content">
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">Add User</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                                <li class="breadcrumb-item active"><a href="/users/create">Add User</a> > <a
                                        href="/users">View Users</a></li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->


          <div class="row">
            <div class="col-md-3"></div>
            <div class="col-md-6">
                <div class="row">
                   

                                        {{-- table --}}

                                        <table class="table table-striped">
                                            <thead>
                                              <tr>
                                                <th scope="col"># </th>
                                                <th scope="col">Name </th>
                                                <th scope="col">Email</th>
                                              </tr>
                                            </thead>
                                            <tbody>
                                             
                                              <tr>
                                                <th scope="row">{{ $user->id }}</th>
                                                <td>
                                                    @if(!empty(  $user->name ))
                                                    {{  $user->name }} 
                                                    @else
                                                    <span> N/A </span>
                                                    @endif 
                    
                                                </td>
                                                <td>
                                                    @if(!empty( $user->email  ))
                                                    {{ $user->email }} 
                                                    @else
                                                    <span> N/A </span>
                                                    @endif 
                    
                                                </td>
                                               
                                              </tr>
                                            </tbody>
                                          </table>
                    
                                        {{-- end of table --}}
                    
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group">
                            <strong>Roles:</strong>
                            @if (!empty($user->getRoleNames()))
                                @foreach ($user->getRoleNames() as $v)
                                <div style="margin-top:15px; margin-right:15px;" class="badge badge-soft-success font-size-18"> {{ $v }}  </div>
    
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3"></div>
          </div>
        </div>
    </div>
@endsection
