@extends('backend.layouts_backend.master')

@section('title')
    All Tours
@endsection


@section('extra_styles')
    <!-- Sweet Alert CSS -->

    <style>
        /* multiple photo upload - environmental activities css */
        .imagePreview {
            width: 100%;
            height: 300px;
            background-position: center center;
            background: url(http://cliquecities.com/assets/no-image-e3699ae23f866f6cbdf8ba2443ee5c4e.jpg);
            background-color: #fff;
            background-size: cover;
            background-repeat: no-repeat;
            1 display: inline-block;
            box-shadow: 0px -3px 6px 2px rgba(0, 0, 0, 0.2);
        }

        .btn-primary {
            display: block;
            border-radius: 0px;
            box-shadow: 0px 4px 6px 2px rgba(0, 0, 0, 0.2);
            margin-top: -5px;
        }

        .imgUp {
            margin-bottom: 15px;
        }

        .del {
            width: 80px;
            height: 40px;
            padding-top: 3px;
            padding-left: 8px;
            padding-right: 8px;
            background-color: #f60909;
            color: #ffffff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        .imgAdd {
            width: 40px;
            height: 40px;
            padding-top: 3px;
            border-radius: 50%;
            background-color: #4bd7ef;
            color: #fff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        .dell {
            width: 40px;
            height: 40px;
            padding-top: 3px;
            border-radius: 50%;
            background-color: #ca078c;
            color: #fff;
            box-shadow: 0px 0px 2px 1px rgba(0, 0, 0, 0.2);
            text-align: center;
            line-height: 30px;
            margin-top: 0px;
            cursor: pointer;
            font-size: 15px;
        }

        /* end of multiple photo upload - environmental activities css */
    </style>
@endsection

@section('content')
    <div class="page-content">
        <div class="container-fluid">


            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">Update Tour </h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        <div>
                            @can('tour-create')
                                <a href="/admin/tours/create" class="btn bg-primary text-light"><i class="bx bx-plus me-1"></i>
                                    Update Tour</a>
                            @endcan
                        </div>

                        <div>
                            @can('tour-restore')
                                <a href="{{ route('tours.trashed') }}" class="btn bg-danger text-light"><i
                                        class="bx bx-plus me-1"></i>
                                    Trashed Tours</a>
                            @endcan
                        </div>


                    </div>

                </div>
            </div>

            <div class="row">
                <div class="col-md-2">

                </div>






                <div class="col-md-8">
                    <form id="updateTourForm" action="{{ route('tours.update', $tour->id) }}" method="post"
                        enctype="multipart/form-data" id="parentForm">
                        @csrf
                        @method('PATCH')

                        <div class="row">

                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label" for="validationCustom01">Tour
                                        Name</label>
                                    <input type="text" class="form-control" id="validationCustom01" name="name"
                                        placeholder="Enter tour name" value="{{ $tour->name }}">
                                    <div>
                                        @error('name')
                                            <small class="text-danger"> {{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label" for="validationCustom01">
                                        Destination</label>
                                    <input type="text" class="form-control" id="validationCustom01" name="destination"
                                        placeholder="Enter destination" value="{{ $tour->destination }}">
                                    <div>
                                        @error('destination')
                                            <small class="text-danger"> {{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Start Date</label>
                                            <input type="date" class="form-control" id="validationCustom01"
                                                name="start_date" placeholder="Enter  start date"
                                                value="{{ $tour->start_date }}">
                                            <div>
                                                @error('start_date')
                                                    <small class="text-danger"> {{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">End Date</label>
                                            <input type="date" class="form-control" id="validationCustom01"
                                                name="end_date" placeholder="Enter  end date" value="{{ $tour->end_date }}">
                                            <div>
                                                @error('end_date')
                                                    <small class="text-danger"> {{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Tour
                                                Category</label>

                                            <select name="tour_category_id" class="form-select">
                                                @foreach ($tour_categories as $tour_category)
                                                    <option value="{{ $tour_category->id }}">
                                                        {{ $tour_category->name }}</option>
                                                @endforeach
                                            </select>

                                            <div>
                                                @error('tour_category_id')
                                                    <small class="text-danger"> {{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Featured
                                                Photo</label>
                                            <input type="file" class="form-control" name="featured_photo"
                                                id="⁠⁠featured_photo" placeholder="">
                                            <div>
                                                @error('⁠⁠featured_photo')
                                                    <small class="text-danger"> {{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>

                                        <hr>

                                        <a href="{!! asset($tour->featured_photo) !!}">
                                            <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                src="{{ asset($tour->featured_photo) }}" alt="preview"
                                                style=" width:100% !important; object-fit:cover;">
                                        </a>
                                        <hr>

                                    </div>



                                </div>


                            </div>

                            {{-- start  multiple column --}}
                            <div class="col-md-12">
                                <div class="row">
                                    {{-- col-1 --}}
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Single tour
                                                cost</label>
                                            <input type="number" class="form-control" id="validationCustom01"
                                                name="tour_single_cost" placeholder="Enter  number of tour_single_cost"
                                                value="{{ $tour->tour_single_cost }}">
                                            <div>
                                                @error('tour_single_cost')
                                                    <small class="text-danger"> {{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    {{-- col-2 --}}
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Couple tour
                                                cost</label>
                                            <input type="number" class="form-control" id="validationCustom01"
                                                name="tour_couple_cost" placeholder="Enter couple tour cost"
                                                value="{{ $tour->tour_single_cost }}">
                                            <div>
                                                @error('tour_couple_cost')
                                                    <small class="text-danger"> {{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- end multiple column --}}

                            {{-- start  multiple column --}}
                            <hr>
                            <div class="col-md-12">
                                <div class="row">
                                    {{-- col-1 --}}
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Tour
                                                Status</label>
                                            <div class="form-check form-check-inline">
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" name="tour_status" type="radio"
                                                        id="tour_status" {{ old('active') == '1' ? 'checked' : '' }}
                                                        {{ $tour->tour_status == '1' ? 'checked' : '' }} value="1">
                                                    <label class="form-check-label" for="tour_status">Active</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" name="tour_status" type="radio"
                                                        id="tour_status" {{ old('unavailable') == '0' ? 'checked' : '' }}
                                                        {{ $tour->tour_status == '0' ? 'checked' : '' }} value="0">
                                                    <label class="form-check-label" for="tour_status">In
                                                        Active</label>
                                                </div>
                                                {{-- validation --}}
                                                @error('tour_status')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror

                                            </div>
                                        </div>
                                    </div>
                                    {{-- col-2 --}}
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label" for="validationCustom01">Tour Booking
                                                availability</label>
                                            <div class="form-check form-check-inline">
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" name="booking_status" type="radio"
                                                        id="booking_status" {{ old('available') == '1' ? 'checked' : '' }}
                                                        {{ $tour->booking_status == '1' ? 'checked' : '' }}
                                                        value="1">
                                                    <label class="form-check-label" for="booking_status">Available</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" name="booking_status" type="radio"
                                                        id="booking_status" {{ old('booked') == '0' ? 'checked' : '' }}
                                                        {{ $tour->booking_status == '0' ? 'checked' : '' }}
                                                        value="0">
                                                    <label class="form-check-label" for="booking_status">Fully
                                                        booked </label>
                                                </div>
                                                {{-- validation --}}
                                                @error('booking_status')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- end multiple column --}}


                            </div>
                            <hr>
                            {{-- end multiple column --}}




                            {{-- itenaries --}}
                            <div class="col-md-12">
                                @php
                                    $tour_itenaries = !empty($tour->tour_itenaries)
                                        ? json_decode($tour->tour_itenaries, true)
                                        : [];
                                @endphp


                                <div class="mb-3">
                                    <div class="card-header  bg-primary" style=" color:#ffffff;">
                                        UPDATE ITENARY ( ADD MULTIPLE )

                                    </div> <br>
                                    {{-- alert delete item --}}
                                    @if (session('messagedelete'))
                                        <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show"
                                            role="alert">
                                            <i class="mdi mdi-block-helper label-icon"></i>
                                            {{ session('messagedelete') }}
                                            <button type="button" class="btn-close" data-bs-dismiss="alert"
                                                aria-label="Close"></button>
                                        </div>
                                    @endif
                                    <hr>



                                    <table class="table color-table inverse-table table-responsive table-borderless"
                                        id="tour_itenaries_details_table">
                                        <thead class="thead-light">
                                            <th>Day Number</th>
                                            <th>Time</th>
                                            <th>Description</th>
                                            <th></th>
                                        </thead>
                                        <tbody id="tour_itenaries_data">
                                            @if (!empty($tour_itenaries))
                                                @foreach ($tour_itenaries as $key => $tour_itenary)
                                                    <tr>
                                                        <td>
                                                            <input type="number" class="form-control"
                                                                name="itenary_day_number[]"
                                                                value="{{ $tour_itenary['itenary_day_number'] }}"
                                                                id="itenary_day_number_1" required>
                                                        </td>
                                                        <td style="min-width: 90px;">
                                                            <div class="input-group">
                                                                <input type="time" class="form-control"
                                                                    name="itenary_time[]"
                                                                    value="{{ $tour_itenary['itenary_time'] }}"
                                                                    id="itenary_time_1" required>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <input type="text" class="form-control"
                                                                name="itenary_description[]"
                                                                value="{{ $tour_itenary['itenary_description'] }}"
                                                                id="itenary_description_1" required>
                                                        </td>
                                                        <td>
                                                            <button onclick="deleteItenaryRow(this)"
                                                                class="btn btn-sm btn-rounded btn-danger"
                                                                title="Delete this row" style="color: white;"
                                                                type="button"><i class="fa fa-trash"></i></button>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            @else
                                                <tr>
                                                    <td>
                                                        <input type="number" class="form-control"
                                                            name="itenary_day_number[]" placeholder="Add day"
                                                            id="itenary_day_number_1" required>
                                                    </td>
                                                    <td style="min-width: 90px;">
                                                        <div class="input-group">
                                                            <input type="time" class="form-control"
                                                                name="itenary_time[]" placeholder="Add time"
                                                                id="itenary_time_1" required>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control"
                                                            name="itenary_description[]" placeholder="Add description"
                                                            id="itenary_description_1" required>
                                                    </td>

                                                    <td></td>
                                                </tr>
                                            @endif



                                        </tbody>
                                    </table>


                                    <button type="button" id="add_tour_itenaries_1"
                                        class="btn btn-success add_tour_itenaries_button label label-inverse"
                                        onclick="add_tour_itenary_row('tour_itenaries_details_table','tour_itenaries_data')">Add
                                        Itenary</button>



                                </div>
                            </div>

                            {{-- activities --}}
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <div class="card-header  bg-primary" style=" color:#ffffff;">
                                        UPDATE ACTIVITY ( UPDATE MULTIPLE )

                                    </div>
                                    <hr>

                                    {{-- activity update --}}
                                    <div id="rowsContainerActivity">

                                        {{-- fetch existing activities --}}
                                        @forelse(json_decode($tour->tour_activities, true) ?? [] as $index => $tour_activity)
                                            <table class="table">
                                                <tbody>
                                                    <tr>
                                                        <td class="col-md-11">

                                                            <input type="text" class="form-control"
                                                                name="tour_activities[]" placeholder="Add activity name"
                                                                value="{{ $tour_activity }}" required>
                                                        </td>

                                                        {{-- delete activity  --}}
                                                        <td class="col-md-1">
                                                            <button onclick="deleteActivityRow(this)"
                                                                class="btn btn-sm btn-rounded btn-danger"
                                                                title="Delete this row" style="color: white;"
                                                                type="button"><i class="fa fa-trash"></i></button>

                                                        </td>
                                                    </tr>

                                                </tbody>
                                            </table>


                                        @empty

                                            <span>No activity found </span>
                                        @endforelse


                                        {{-- end fetch existing activities --}}
                                    </div>

                                    <button type="button" class="btn btn-success" onclick="addRowActivity()">Add
                                        Activity</button>
                                    {{-- end itenary add --}}


                                </div>
                            </div>

                            {{-- Tour includes and excludes --}}
                            {{-- tour includes --}}
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <div class="card-header  bg-primary" style=" color:#ffffff;">
                                        UPDATE TOUR INCLUDES ( UPDATE MULTIPLE )

                                    </div>
                                    <hr>

                                    <div id="rowsContainerIncludes">
                                        @forelse(json_decode($tour->tour_includes, true) ?? [] as $index => $tour_include)
                                            <div class="row mb-2">
                                                {{-- Fetch existing tour includes --}}

                                                <div class="col-md-8">
                                                    <input type="text" class="form-control" name="tour_includes[]"
                                                        value="{{ $tour_include }}">
                                                </div>

                                                {{-- end fetch existing tour includes --}}

                                                <div class="col-md-2">
                                                    <button type="button" class="btn btn-danger"
                                                        onclick="removeRowIncludes(this)">Remove</button>
                                                </div>
                                            </div>
                                        @empty

                                            <span>No includes </span>
                                        @endforelse


                                    </div>

                                    <button type="button" class="btn btn-success" onclick="addRowIncludes()">Add
                                        Include</button>
                                    {{-- end itenary add --}}


                                </div>

                            </div>

                            {{-- tour excludes --}}
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <div class="card-header  bg-primary" style=" color:#ffffff;">
                                        TOUR EXCLUDES ( ADD MULTIPLE )

                                    </div>
                                    <hr>

                                    <div id="rowsContainerExcludes">
                                        {{-- fetch existing tour excludes --}}
                                        @forelse(json_decode($tour->tour_excludes, true) ?? [] as $index => $tour_exclude)
                                            <div class="row mb-2">

                                                <div class="col-md-8">
                                                    <input type="text" class="form-control" name="tour_excludes[]"
                                                        value="{{ $tour_exclude }}" placeholder="Exclude" required>
                                                </div>
                                                <div class="col-md-2">
                                                    <button type="button" class="btn btn-danger"
                                                        onclick="removeRowExcludes(this)">Remove</button>
                                                </div>
                                            </div>

                                        @empty

                                            <span>No tour excludes </span>
                                        @endforelse
                                        {{-- end of existing tour excludes --}}
                                    </div>

                                    <button type="button" class="btn btn-success" onclick="addRowExcludes()">Add
                                        Exclude</button>
                                    {{-- end itenary add --}}


                                </div>

                            </div>


                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="validationCustom01">3D Video Link
                                        (Youtube)</label>
                                    <input type="text" class="form-control" id="validationCustom01" name="video_url"
                                        placeholder="Enter video link from youtube"
                                        value="http://www.youtube.com/embed/replace_with_video_id">
                                    <div>
                                        @error('video_url')
                                            <small class="text-danger"> {{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="validationCustom01">Slots available </label>
                                    <input type="number" class="form-control" id="validationCustom01"
                                        name="slots_available" placeholder="Slots avialable"
                                        value="{{ $tour->slots_available }}">
                                    <div>
                                        @error('slots_available')
                                            <small class="text-danger"> {{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>


                            <hr>
                            {{-- end multiple column --}}


                            {{-- photo library upload --}}

                            <div class="card" style="margin-top:20px; padding-top:10px;">
                                <div class="card-header bg-primary" style=" color:#ffffff;">
                                    Update Tour photos gallery

                                </div>
                                <div class="card-body">

                                    {{-- validation --}}
                                    @error('photo_library')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror


                                    <div class="row">
                                        @if (!empty($tour->photo_library))
                                            <input type="hidden" name="tour_id" value="{{ $tour->id }}">
                                            <table>
                                                <tbody>
                                                    @foreach (is_null($tour->photo_library) ? [] : explode(',', $tour->photo_library) as $image)
                                                        <tr>
                                                            {{-- START COL --}}
                                                            <div class=" col-md-6 col-sm-6 col-xs-12">
    
                                                                <a href="{!! asset($image) !!}"> <img
                                                                        style=" height: 200px; 
                                                                    background-color:#ffffff; 
                                                                    object-fit:cover;
                                                                    width:100% !important;
                                                                    border:#ffffff 2px solid;
                                                                    background-repeat: no-repeat;
                                                                    object-position: center center;
                                                                    background-size:cover;
                                                                    padding:7px; 
                                                                    margin:0px;"
                                                                        src="{{ asset($image) }}" alt="">
    
                                                                </a>
                                                                {{-- <a
                                                                    href="{{ route('apartment.delete_apartment_image', $image) }}">Delete</a> --}}
                                                                <button class="btn btn-primary delete-tour-image-btn" 
                                                                    data-image="{{ $image }}">Delete
                                                                    Image</button>
                                                            </div>
    
                                                            {{-- END COL --}}
                                                        </tr>
                                                </tbody>
                                        @endforeach
                                        </table>
                                    @else
                                        <center><span>No Photos Available <span></center>
                                        @endif
                                    </div>

                                    <hr>

                                    <div class="card-body">
                                        @error('photo_library')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror

                                        <input type="file" multiple class="form-control" name="photo_library[]"  id="upload_multiple">
                                    </div>

                                    {{-- <div class="row" style="margin-top:40px;">
                                        <div class="col-md-6 imgUp">
                                            <div class="imagePreview"></div>
                                            <label class="btn btn-primary">
                                                Add Photo
                                                <input type="file" name="photo_library[]" class="uploadFile img"
                                                    value="Upload Photo" style="width: 0px;height: 0px;overflow: hidden;">


                                            </label>

                                        </div><!-- col-2 -->
                                        <i class="bi bi-plus-lg imgAdd">

                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                fill="currentColor" class="bi bi-plus-lg" viewBox="0 0 16 16">
                                                <path fill-rule="evenodd"
                                                    d="M8 2a.5.5 0 0 1 .5.5v5h5a.5.5 0 0 1 0 1h-5v5a.5.5 0 0 1-1 0v-5h-5a.5.5 0 0 1 0-1h5v-5A.5.5 0 0 1 8 2" />
                                            </svg>
                                        </i>

                                    </div> --}}


                                </div>
                            </div>

                            {{-- end of photo library upload --}}

                            {{-- description --}}

                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label" for="validationCustom01">Description</label>

                                    <textarea class="form-control" name="description" id="exampleFormControlTextarea5" placeholder="Describe the tour"
                                        rows="3">{{ $tour->description }}</textarea>
                                    <div>
                                        @error('description')
                                            <small class="text-danger"> {{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                            </div>


                            <!-- Editor -->




                            <button onclick="submitInnerForm2()" class="btn btn-primary" type="submit">Update
                                Tour</button>
                    </form>
                </div>

                <div class="col-md-2">

                </div>
            </div>
        </div>
    </div>
@endsection

@section('extra_scripts')
    {{-- add itenary row  and delete itenary row --}}
    {{-- <script src="{{ asset('assets/backend_assets/assets/js/tours/itenaries_add_remove_row.js') }}"></script> --}}

    {{--  <script src="{{ asset('assets/backend_assets/assets/js/tours/itenaries_add_remove_row_update.js') }}"></script> --}}


    {{-- add activity row  and delete activity row --}}
    {{-- <script src="{{ asset('assets/backend_assets/assets/js/tours/activities_add_remove_row.js') }}"></script> --}}


    {{-- tour excludes , add and remove rows --}}
    <script src="{{ asset('assets/backend_assets/assets/js/tours/tour_excludes_add_remove_row.js') }}"></script>

    {{-- tour includes , add and remove rows --}}
    <script src="{{ asset('assets/backend_assets/assets/js/tours/tour_includes_add_remove_row.js') }}"></script>



    {{-- multiple photo upload - environmental activities script --}}
    <script type="text/javascript">
        $(".imgAdd").click(function() {
            $(this).closest(".row").find('.imgAdd').before(
                '<div class="col-md-6 imgUp"><div class="imagePreview"></div><label class="btn btn-primary">Upload<input type="file" name="photo_library[]" class="uploadFile img" value="Upload Photo" style="width:0px;height:0px;overflow:hidden;"></label><i class="fa fa-timess del"><span style="color:#ffffff; ">Remove</span></i></div>'
            );
        });
        $(document).on("click", "i.del", function() {
            // 	to remove card
            $(this).parent().remove();
            // to clear image
            // $(this).parent().find('.imagePreview').css("background-image","url('')");
        });
        $(function() {
            $(document).on("change", ".uploadFile", function() {
                var uploadFile = $(this);
                var files = !!this.files ? this.files : [];
                if (!files.length || !window.FileReader)
                    return; // no file selected, or no FileReader support

                if (/^image/.test(files[0].type)) { // only image file
                    var reader = new FileReader(); // instance of the FileReader
                    reader.readAsDataURL(files[0]); // read the local file

                    reader.onloadend = function() { // set image data as background of div
                        //alert(uploadFile.closest(".upimage").find('.imagePreview').length);
                        uploadFile.closest(".imgUp").find('.imagePreview').css("background-image",
                            "url(" + this.result + ")");
                    }
                }

            });
        });
    </script>


    {{-- end of  multiple photo upload - environmental activities script --}}

    {{-- add tour activity --}}
    <script>
        var rowCounterActivity = 0;

        function addRowActivity() {
            rowCounterActivity++;

            var newRowActivity = ` <table class="table">
                                        <tbody>
                                            <tr>
                                                <td class="col-md-11">
                                                    <input type="text" class="form-control" name="tour_activities[]" placeholder="Add Activity" required>
                                                </td>
                                                <td class="col-md-1">
                                                    <button onclick="deleteActivityRow(this)" class="btn btn-sm btn-rounded btn-danger" title="Delete this row" style="color: white;" type="button"><i class="fa fa-trash"></i></button>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                 `;

            $('#rowsContainerActivity').append(newRowActivity);
        }
    </script>

    {{-- add tour itenary row --}}
    <script>
        function add_tour_itenary_row(table_id, body_id) {
            var id = document.getElementById(table_id).rows.length + 1;
            if (body_id == 'tour_itenaries_data') {
                $('#tour_itenaries_data').append(`
                <tr>
                   <td>
                       <input type="number" class="form-control" name="itenary_day_number[]" placeholder="Add day" id="itenary_day_number_${id}"  required>
                   </td>
                   <td style="min-width: 90px;">
                       <div class="input-group">
                           <input type="time" class="form-control" name="itenary_time[]" placeholder="Add time" id="itenary_time_${id}" required>
                       </div>
                   </td>
                   <td>                            
                       <input type="text" class="form-control"  name="itenary_description[]" placeholder="Add description" id="itenary_description_${id}"  required>
                   </td> 
                   <td>
                       <button onclick="deleteItenaryRow(this)" class="btn btn-sm btn-rounded btn-danger" title="Delete this row" style="color: white;" type="button"><i class="fa fa-trash"></i></button>
                    </td>                        
               </tr>
           `);
            }

        }

        /* delete itenary row */
        function deleteItenaryRow(ele) {
            ele.parentNode.parentNode.remove();
        }

        // db  delete activity row
        function deleteActivityRow(ele) {
            ele.parentNode.parentNode.remove();
        }
    </script>

    {{-- delete tour image with ajax --}}
    <script>
        // in header section  in master of file //<meta name="csrf-token" content="{{ csrf_token() }}">
        $(document).ready(function() {
            $('.delete-tour-image-btn').click(function(e) {
                e.preventDefault();

                // Get image URL from data attribute
                var image = $(this).data('image');

                // Confirm deletion
                // if (!confirm('Are you sure you want to delete this image?')) {
                //     return;
                // }

                Swal.fire({
                    title: 'Are you sure?',
                    text: 'Are you sure you want to delete this image?',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Code to execute if the user confirms
                        // Send AJAX request
                        $.ajax({
                            url: '{{ route('tour.delete_tour_image', ['id' => $tour->id]) }}',
                            method: 'DELETE',
                            data: {
                                _token: '{{ csrf_token() }}',
                                image: image
                            },
                            success: function(response) {
                                // success response
                                console.log(response);
                                // Optionally, remove the deleted image from the DOM
                                $(e.target).closest('div').remove();
                            },
                            error: function(xhr, status, error) {
                                // Handle error response (if needed)
                                console.error(xhr.responseText);
                            }
                        });
                    }
                });


            });
        });
    </script>
@endsection
