{{-- @extends('layouts.app') --}}
@extends('backend.layouts_backend.master')

@section('title')
    View roles
@endsection
@section('content')
    <!-- Main content dashboard  -->
    <div class="page-content">
        <div class="container-fluid">

              <!-- start page title -->
              <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">All Roles ( {{ $count_roles  }} )</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="/admin/dashboard">Dashboard</a></li>
                                <li class="breadcrumb-item active"><a href="/admin/roles/create">Add Roles </a> > <a href="/admin/roles">View Roles</a></li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->



            {{-- alert add item --}}
            @if(session('messagesave'))
            {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
            <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
               <i class="mdi mdi-check-all label-icon"></i>
               {{ session('messagesave')}}
               <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
           </div>
           @endif

            {{-- alert delete item --}}
             @if(session('messagedelete'))
            <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
               <i class="mdi mdi-block-helper label-icon"></i>
               {{ session('messagedelete')}}
               <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
           </div>
             {{-- <div class="alert alert-danger" > {{ session('messagedelete')}} </div> --}}
            @endif

            {{-- alert update item --}}
             @if(session('messageupdate'))
            <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
               <i class="mdi mdi-check-all label-icon"></i>
               {{ session('messageupdate')}}
               <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
           </div>
           @endif


            <table class="table table-bordered">
                <tr>
                    <th>#ID</th>
                    <th>Name</th>
                    <th width="280px">Action</th>
                </tr>
                @foreach ($roles as $key => $role)
                    <tr>
                        <td>{{ ++$i }}</td>
                        <td>{{ $role->name }}</td>
                        <td>
                            <a class="btn btn-info" href="{{ route('roles.show', $role->id) }}">Show</a>
                            @can('role-edit')
                                <a class="btn btn-primary" href="{{ route('roles.edit', $role->id) }}">Edit</a>
                            @endcan
                            @can('role-delete')
                                {!! Form::open(['method' => 'DELETE', 'route' => ['roles.destroy', $role->id], 'style' => 'display:inline']) !!}
                                {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                {!! Form::close() !!}
                            @endcan
                        </td>
                    </tr>
                @endforeach
            </table>


            {!! $roles->render() !!}
        @endsection
