{{-- @extends('layouts.app') --}}
@extends('backend.layouts_backend.master')

@section('title')
    Edit Role
@endsection
@section('content')


    <!-- Main content dashboard  -->
    <div class="page-content">
        <div class="container-fluid">

               <!-- start page title -->
               <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">Edit Role</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                                <li class="breadcrumb-item active"><a href="/roles/create">Add Roles </a> > <a href="/roles">View Roles</a></li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->





            @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <strong>Whoops!</strong> There were some problems with your input.<br><br>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif


            {!! Form::model($role, ['method' => 'PATCH', 'route' => ['roles.update', $role->id]]) !!}
            <div class="row">
                <div class="col-xs-12 col-sm-12 col-md-12">
                    <div class="form-group">
                        <strong>Name:</strong>
                        {!! Form::text('name', null, ['placeholder' => 'Name', 'class' => 'form-control']) !!}
                    </div>
                </div>
               <div class="row" style="margin-top:30px;">
                <strong>Permission:</strong>
                <br> <br>
                <hr>
                @foreach ($permission as $value)
                <div class="col-md-3" >
                    <div class="form-group">
                       

                        <br>
                        
                        
                            <label>{{ Form::checkbox('permission[]', $value->id, in_array($value->id, $rolePermissions) ? true : false, ['class' => 'name']) }}
                                {{ $value->name }}</label>
                            <br />
                        
                    </div>
                </div>
                @endforeach
               </div>
               <hr>
                <div class="col-xs-12 col-sm-12 col-md-12">
                    <button type="submit" class="btn btn-primary">Edit Role </button>
                </div>
            </div>
            {!! Form::close() !!}
            <br><br>
        </div>
    </div>


@endsection
