{{-- @extends('layouts.app') --}}
@extends('backend.layouts_backend.master')

@section('title')
    Add Role
@endsection
@section('content')


    <!-- Main content dashboard  -->
    <div class="page-content">
        <div class="container-fluid">

             <!-- start page title -->
             <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">Add Role</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="/dashboard">Dashboard</a></li>
                                <li class="breadcrumb-item active"><a href="/roles/create">Add Roles </a> </li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->


            {!! Form::open(['route' => 'roles.store', 'method' => 'POST']) !!}
            <div class="row">
                <div class="col-xs-12 col-sm-12 col-md-12" >
                    <div class="form-group">
                        <strong>Role Name:</strong>
                        {!! Form::text('name', null, ['placeholder' => 'Enter role name', 'class' => 'form-control']) !!}
                    </div>
                    {{-- validation --}}
                    @if ($errors->has('name'))
                        <span class="text-danger text-left">{{ $errors->first('name') }}</span>
                    @endif

                </div>
                <div class="col-xs-12 col-sm-12 col-md-12" style="margin-top:20px; ">
                    <div class="form-group">
                        <strong>Select Permissions :</strong> <br>
                                {{-- validation --}}
                        @if ($errors->has('permission'))
                            <span class="text-danger text-left">{{ $errors->first('permission') }}</span>
                        @endif
                        <hr>
                        
                        {{-- permissions --}}
                        <div class="row">
                            @foreach ($permission as $value)
                            <div class="col-md-3">
                                <label>{{ Form::checkbox('permission[]', $value->id, false, ['class' => 'name']) }}
                                    {{ $value->description }}</label>
                                <br />
                            </div>
                            @endforeach
                        </div>
                       
                    </div>
                </div>
                <br>
                <hr>
                <div class="col-xs-12 col-sm-12 col-md-12" style="margin-top:30px;">
                    <button type="submit" class="btn btn-primary">Add Role</button>
                </div>
            </div>
            {!! Form::close() !!}


        </div>
        <!-- container-fluid -->
    </div>
@endsection
