@extends('backend.layouts_backend.master')

@section('title')
    All Emergency cases reports data
@endsection

@section('content')
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">All Emergency cases reports data <span
                                class="text-muted fw-normal ms-2">({{ $count_emergency_cases }})</span></h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        {{-- @can('emergency_case-create')
                            <div>
                                <a href="/emergency_cases/create" class="btn bg-primary text-light"><i
                                        class="bx bx-plus me-1"></i> Add Emergency case
                                </a>
                            </div>
                        @endcan --}}


                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH emergency_caseS -->
            {{--  MESSAGES --}}
            <!-- FETCH FEEDBACKS -->
            {{-- alert add item --}}
            @if (session('messagesave'))
                {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagesave') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert delete item --}}
            @if (session('messagedelete'))
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    {{ session('messagedelete') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                {{-- <div class="alert alert-danger" > {{ session('messagedelete')}} </div> --}}
            @endif

            {{-- alert update item --}}
            @if (session('messageupdate'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messageupdate') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif




            <div class="table-responsive mb-4">
                <table class="table align-middle datatable dt-responsive table-check nowrap"
                    style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                    <thead>
                        <tr>

                            <th scope="col">#ID</th>
                            <th scope="col">Full Name</th>
                            <th scope="col">Created By</th>
                            <th scope="col">Assigned To</th>
                            <th scope="col">Priority</th>
                            <th scope="col">Case Status </th>
                            <th style="width: 150px; min-width: 80px;">Action </th>
                        </tr>
                    </thead>
                    <tbody>

                        @forelse ($emergency_cases as $emergency_case)
                            <tr>

                                <td>{{ $emergency_case->id }}</td>
                                <td>
                                    @if (!empty($emergency_case->tenant_r->fullname))
                                        {{ $emergency_case->tenant_r->fullname }}
                                    @else
                                        <button class="btn btn-danger shadow btn-xs sharp">
                                            <span class="fa fa-exclamation-circle"> No Tenant</span>
                                        </button>
                                    @endif
                                </td>

                                <td>
                                    @if (!empty($emergency_case->created_by))
                                        {{ $emergency_case->created_by }}
                                    @else
                                        <button class="btn btn-danger shadow btn-xs sharp">
                                            <span class="fa fa-exclamation-circle"> No Responder</span>
                                        </button>
                                    @endif
                                </td>

                                <td>
                                    @if (!empty($emergency_case->user_r->name))
                                        {{ $emergency_case->user_r->name }}
                                    @else
                                        <button class="btn btn-danger shadow btn-xs sharp">
                                            <span class="fa fa-exclamation-circle"> None assigned </span>
                                        </button>
                                    @endif

                                </td>

                                <td>

                                    @if (!empty($emergency_case->priority == 'high'))
                                        <span class="badge rounded-pill badge-soft-success font-size-18 fw-medium">
                                            {{ $emergency_case->priority }}
                                        </span>
                                    @elseif (!empty($emergency_case->priority == 'medium'))
                                        <span class="badge rounded-pill badge-soft-warning font-size-18 fw-medium">
                                            {{ $emergency_case->priority }}
                                        </span>
                                    @elseif (!empty($emergency_case->priority == 'low'))
                                        <span class="badge rounded-pill badge-soft-danger font-size-18 fw-medium">
                                            {{ $emergency_case->priority }}
                                        </span>
                                    @else
                                        <p class="text-danger">No priority</p>
                                    @endif

                                </td>

                                <td>
                                    @if (!empty($emergency_case->status == 'pending'))
                                        <span class="badge rounded-pill badge-soft-warning font-size-18 fw-medium">
                                            {{ $emergency_case->status }}
                                        </span>
                                    @elseif (!empty($emergency_case->status == 'assigned'))
                                        <span class="badge rounded-pill badge-soft-success font-size-18 fw-medium">
                                            {{ $emergency_case->status }}
                                        </span>
                                    @elseif (!empty($emergency_case->status == 'processing'))
                                        <span class="badge rounded-pill badge-soft-danger font-size-18 fw-medium">
                                            {{ $emergency_case->status }}
                                        </span>
                                    @elseif (!empty($emergency_case->status == 'verified'))
                                        <span class="badge rounded-pill badge-soft-success font-size-18 fw-medium">
                                            {{ $emergency_case->status }}
                                        </span>
                                    @elseif (!empty($emergency_case->status == 'queried'))
                                        <span class="badge rounded-pill badge-soft-success font-size-18 fw-medium">
                                            {{ $emergency_case->status }}
                                        </span>
                                    @elseif (!empty($emergency_case->status == 'closed'))
                                        <span class="badge rounded-pill badge-soft-danger font-size-18 fw-medium">
                                            {{ $emergency_case->status }}
                                        </span>
                                    @else
                                        <p class="text-danger">No status</p>
                                    @endif
                                </td>


                                <td colspan="6">
                                    <div class="row">


                                        @can('emergency_case-list')
                                        <div class="col-md-4">
                                            <button type="button" class="btn btn-success" data-bs-toggle="modal"
                                                data-bs-target="#viewemergency_caseDetails{{ $emergency_case->id }}"
                                                data-bs-whatever="@getbootstrap"><i class=" far fa-eye  "></i></button>
                                        </div>
                                        @endcan

                                        @can('report-download')
                                        <div class="col-md-4">
                                            <a href="/emergency_report/{{ $emergency_case->id }}" target="_blank"><button
                                                    type="button" class="btn btn-secondary">
                                                    <i class="bx bx-download label-icon "></i>
                                                </button>
                                            </a>
                                        </div>
                                        @endcan


                                        {{-- @can('emergency_case-edit')
                                        <div class="col-md-4">
                                            <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                data-bs-target="#editemergency_case{{ $emergency_case->id }}"
                                                data-bs-whatever="@getbootstrap"><i class="fas fa-pencil-alt "></i></button>

                                        </div>
                                        @endcan --}}

                                        <!-- delete food menu -->
                                        {{--
                                        @can('emergency_case-delete')
                                        <div class="col-md-4">
                                            <form action="{{ route('emergency_cases.update', $emergency_case->id) }}"
                                                method="post">
                                                @csrf
                                                @method('DELETE')
                                                <a> <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                            class="fa fa-trash"> </button> </a>

                                            </form>
                                        </div>
                                        @endcan --}}


                                    </div>
                                </td>
                            </tr>

                            <!-- VIEW DETAILS MODEL -->
                            <div class="modal fade" id="viewemergency_caseDetails{{ $emergency_case->id }}" tabindex="-1"
                                aria-labelledby="viewemergency_caseDetailsLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewemergency_caseDetailsLabel"> Emergeny case
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>



                                        <div class="modal-body">


                                            <b>
                                                <p style="font-size: 20px;"> Shelter/Residence name:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->fullname))
                                                    {{ $emergency_case->fullname }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No fullname</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Created by:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->created_by))
                                                    {{ $emergency_case->created_by }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No created by</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Assigned to:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->user_r->name))
                                                    {{ $emergency_case->user_r->name }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> None assigned </span>
                                                    </button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Status:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->status == 'pending'))
                                                    <span
                                                        class="badge rounded-pill badge-soft-warning font-size-18 fw-medium">
                                                        {{ $emergency_case->status }}
                                                    </span>
                                                @elseif (!empty($emergency_case->status == 'assigned'))
                                                    <span
                                                        class="badge rounded-pill badge-soft-success font-size-18 fw-medium">
                                                        {{ $emergency_case->status }}
                                                    </span>
                                                @elseif (!empty($emergency_case->status == 'processing'))
                                                    <span
                                                        class="badge rounded-pill badge-soft-danger font-size-18 fw-medium">
                                                        {{ $emergency_case->status }}
                                                    </span>
                                                @elseif (!empty($emergency_case->status == 'verified'))
                                                    <span
                                                        class="badge rounded-pill badge-soft-success font-size-18 fw-medium">
                                                        {{ $emergency_case->status }}
                                                    </span>
                                                @elseif (!empty($emergency_case->status == 'queried'))
                                                    <span
                                                        class="badge rounded-pill badge-soft-success font-size-18 fw-medium">
                                                        {{ $emergency_case->status }}
                                                    </span>
                                                @elseif (!empty($emergency_case->status == 'closed'))
                                                    <span
                                                        class="badge rounded-pill badge-soft-danger font-size-18 fw-medium">
                                                        {{ $emergency_case->status }}
                                                    </span>
                                                @else
                                                    <p class="text-danger">No status</p>
                                                @endif
                                            </p>


                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Priority:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->priority == 'high'))
                                                    <span
                                                        class="badge rounded-pill badge-soft-success font-size-18 fw-medium">
                                                        {{ $emergency_case->priority }}
                                                    </span>
                                                @elseif (!empty($emergency_case->priority == 'medium'))
                                                    <span
                                                        class="badge rounded-pill badge-soft-warning font-size-18 fw-medium">
                                                        {{ $emergency_case->priority }}
                                                    </span>
                                                @elseif (!empty($emergency_case->priority == 'low'))
                                                    <span
                                                        class="badge rounded-pill badge-soft-danger font-size-18 fw-medium">
                                                        {{ $emergency_case->priority }}
                                                    </span>
                                                @else
                                                    <p class="text-danger">No priority</p>
                                                @endif
                                            </p>


                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Emergecy case phone number:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->phone_number))
                                                    {{ $emergency_case->phone_number }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No Phone</button>
                                                @endif
                                            </p>
                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Email:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->email))
                                                    {{ $emergency_case->email }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No email</button>
                                                @endif
                                            </p>
                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Current address:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->current_address))
                                                    {{ $emergency_case->current_address }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No address</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Organization name worked with:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->organization_name_worked_with))
                                                    {{ $emergency_case->organization_name_worked_with }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No organization</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Organization address worked with:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->organization_address_worked_with))
                                                    {{ $emergency_case->organization_address_worked_with }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No address</button>
                                                @endif
                                            </p>


                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Organization position:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->organization_position))
                                                    {{ $emergency_case->organization_position }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No position</button>
                                                @endif
                                            </p>


                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Date of birth:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->date_of_birth))
                                                    {{ $emergency_case->date_of_birth }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No date</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Gender:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->gender))
                                                    {{ $emergency_case->gender }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No gender</button>
                                                @endif
                                            </p>
                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Person name to contact in emergency:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->person_name_to_contact_incase_of_emergency))
                                                    {{ $emergency_case->person_name_to_contact_incase_of_emergency }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No person</button>
                                                @endif
                                            </p>


                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Person email to contact in emergency:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->person_email_to_contact_incase_of_emergency))
                                                    {{ $emergency_case->person_email_to_contact_incase_of_emergency }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No email</button>
                                                @endif
                                            </p>


                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Person phone in emergency:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->person_phone_to_contact_incase_of_emergency))
                                                    {{ $emergency_case->person_phone_to_contact_incase_of_emergency }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No phone</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;">
                                                    Details of LGBT+ rights activities involved in
                                                    including organizations and dates worked for and the duration:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->activities_done))
                                                    {{ $emergency_case->activities_done }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No activities</button>
                                                @endif
                                            </p>


                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> What happended ?:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->what_happened))
                                                    {{ $emergency_case->what_happened }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No data</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> When it happened:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->when_it_happened))
                                                    {{ $emergency_case->when_it_happened }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No date</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Where it happened:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->where_it_happened))
                                                    {{ $emergency_case->where_it_happened }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No data</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Why it happened:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->why_it_happened))
                                                    {{ $emergency_case->why_it_happened }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No place</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Support needed:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->support_needed))
                                                    {{ $emergency_case->support_needed }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No support data</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> What can we do ?:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->what_can_we_do))
                                                    {{ $emergency_case->what_can_we_do }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No data</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Budget:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->budget))
                                                    {{ $emergency_case->budget }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No budget</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Sustainability plan:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->sustainability_plan))
                                                    {{ $emergency_case->sustainability_plan }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No
                                                            sustainability_plan</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Secondary person name:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->secondary_person_name))
                                                    {{ $emergency_case->secondary_person_name }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No name</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Secondary person email:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->secondary_person_email))
                                                    {{ $emergency_case->secondary_person_email }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No email</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Secondary person phone:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->secondary_person_phone))
                                                    {{ $emergency_case->secondary_person_phone }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No phone</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Written evidence:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->written_evidence))
                                                    {{ $emergency_case->written_evidence }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No written evidence
                                                            provided</button>
                                                @endif
                                            </p>


                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Comment on case:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($emergency_case->comment_on_case))
                                                    {{ $emergency_case->comment_on_case }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No comment</button>
                                                @endif
                                            </p>


                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Evidence photo 1:</p>
                                            </b>
                                            @if ($emergency_case->photo_evidence_one)
                                                <a href="{!! asset($emergency_case->photo_evidence_one) !!}">
                                                    <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                        src="{{ asset($emergency_case->photo_evidence_one) }}"
                                                        alt="preview" style=" width:100% !important; object-fit:cover;">
                                                </a>
                                            @else
                                                <p class="text-danger">No evidence 1</p>
                                            @endif


                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Evidence photo 2:</p>
                                            </b>
                                            @if ($emergency_case->photo_evidence_two)
                                                <a href="{!! asset($emergency_case->photo_evidence_two) !!}">
                                                    <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                        src="{{ asset($emergency_case->photo_evidence_two) }}"
                                                        alt="preview" style=" width:100% !important; object-fit:cover;">
                                                </a>
                                            @else
                                                <p class="text-danger">No evidence 2</p>
                                            @endif



                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Evidence photo 3:</p>
                                            </b>
                                            @if ($emergency_case->photo_evidence_three)
                                                <a href="{!! asset($emergency_case->photo_evidence_three) !!}">
                                                    <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                        src="{{ asset($emergency_case->photo_evidence_three) }}"
                                                        alt="preview" style=" width:100% !important; object-fit:cover;">
                                                </a>
                                            @else
                                                <p class="text-danger">No evidence 3</p>
                                            @endif

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Evidence photo 4:</p>
                                            </b>
                                            @if ($emergency_case->photo_evidence_four)
                                                <a href="{!! asset($emergency_case->photo_evidence_four) !!}">
                                                    <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                        src="{{ asset($emergency_case->photo_evidence_four) }}"
                                                        alt="preview" style=" width:100% !important; object-fit:cover;">
                                                </a>
                                            @else
                                                <p class="text-danger">No evidence 4</p>
                                            @endif






















                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close
                                            </button>

                                            @can('emergency_case-edit')
                                                <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                    data-bs-target="#editemergency_case{{ $emergency_case->id }}"
                                                    data-bs-whatever="@getbootstrap">Edit emergency case
                                                </button>
                                            @endcan

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- END OF VIEW DETAILS MODEL -->


                            {{-- UPDATE DETAILS emergency_case --}}
                            <div class="modal fade" id="editemergency_case{{ $emergency_case->id }}" tabindex="-1"
                                aria-labelledby="editemergency_caseLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewemergency_caseDetailsLabel">Edit emergency
                                                case
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">


                                            <!-- UPDATE post CATEGORIES -->

                                            <form action="{{ route('emergency_cases.update', $emergency_case->id) }}"
                                                method="post" enctype="multipart/form-data">
                                                @csrf
                                                @method('PATCH')

                                                {{-- START FORM --}}
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Name of the
                                                                client?
                                                                (Tenant)
                                                            </label>

                                                            <select name="tenant_id" class="form-select">


                                                                @foreach ($tenants as $tenant)
                                                                    <option value="{{ $tenant->id }}"
                                                                        @selected($tenant->id == $emergency_case->tenant_id)>
                                                                        {{ $tenant->fullname }}
                                                                    </option>
                                                                @endforeach
                                                            </select>



                                                            <div>
                                                                @error('tenant_id')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Client
                                                                Phone number</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="phone_number"
                                                                placeholder="Enter client phone number"
                                                                value="{{ $emergency_case->phone_number }}">
                                                            <div>
                                                                @error('phone_number')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="row">

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Case
                                                                Created By</label>
                                                            <input type="text" class="form-control" name="created_by"
                                                                id="validationCustom02" placeholder="Created by"
                                                                value="{{ $created_by }}" style="pointer-events: none">
                                                            <div>
                                                                @error('created_by')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Assign case
                                                                to</label>
                                                            <select name="user_id" class="form-select">
                                                                @foreach ($users as $user)
                                                                    <option value="{{ $user->id }}">
                                                                        {{ $user->name }}</option>
                                                                @endforeach
                                                            </select>
                                                            <div>
                                                                @error('date_of_birth')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>


                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Case
                                                                Priority</label>
                                                            <select name="priority" class="form-select">
                                                                <option value="high" @selected($emergency_case->priority == 'high')>High
                                                                </option>
                                                                <option value="medium" @selected($emergency_case->priority == 'medium')>Medium
                                                                </option>
                                                                <option value="low" @selected($emergency_case->priority == 'low')>Low
                                                                </option>

                                                            </select>
                                                            <div>
                                                                @error('date_of_birth')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Client
                                                                Email</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="email"
                                                                placeholder="Enter client email"
                                                                value="{{ $emergency_case->email }}">
                                                            <div>
                                                                @error('email')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>


                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Client
                                                                present address</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="current_address"
                                                                placeholder="Enter client present address"
                                                                value="{{ $emergency_case->current_address }}">
                                                            <div>
                                                                @error('current_address')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>



                                                </div>

                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Client’s
                                                                LGBT+ Rights
                                                                Organization name worked with, If Available</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01"
                                                                name="organization_name_worked_with"
                                                                placeholder="Enter if available - Optional"
                                                                value="{{ $emergency_case->organization_name_worked_with }}">
                                                            <div>
                                                                @error('organization_name_worked_with')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Client’s
                                                                LGBT+ Rights
                                                                Organization address worked with, If Available</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01"
                                                                name="organization_address_worked_with"
                                                                placeholder="Enter if available -  Optional"
                                                                value="{{ $emergency_case->organization_address_worked_with }}">
                                                            <div>
                                                                @error('organization_name_worked_with')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="row">

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Client’s
                                                                Position Held At Organization, If Available?</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="organization_position"
                                                                placeholder="Enter position if available"
                                                                value="{{ $emergency_case->organization_position }}">
                                                            <div>
                                                                @error('organization_position')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>


                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Case
                                                                status</label>
                                                            <select name="status" class="form-select">
                                                                <option value="pending" @selected($emergency_case->status == 'pending')>
                                                                    Pending (When the emergency case is
                                                                    received)</option>
                                                                <option value="assigned" @selected($emergency_case->status == 'assigned')>
                                                                    Assigned (When the responder is
                                                                    given a case)</option>
                                                                <option value="processing" @selected($emergency_case->status == 'processing')>
                                                                    Processing (When the responder
                                                                    is working on the case)</option>
                                                                <option value="verified" @selected($emergency_case->status == 'verified')>
                                                                    Verified (When the responder is
                                                                    done doing his part)</option>
                                                                <option value="queried" @selected($emergency_case->status == 'queried')>
                                                                    Queried (When some data is missing)
                                                                </option>
                                                                <option value="closed" @selected($emergency_case->status == 'closed')>Closed
                                                                    (This can only be done by the
                                                                    admin after requested assistance has been availed)
                                                                </option>
                                                            </select>
                                                            <div>
                                                                @error('gender')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Clients
                                                                Date of
                                                                birth</label>
                                                            <input type="date" class="form-control"
                                                                id="validationCustom01" name="date_of_birth"
                                                                placeholder="Enter date"
                                                                value="{{ $emergency_case->date_of_birth }}">
                                                            <div>
                                                                @error('date_of_birth')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Clients
                                                                Gender</label>
                                                            <select name="gender" class="form-select">
                                                                <option value="male" @selected($emergency_case->gender == 'male')>Male
                                                                </option>
                                                                <option value="female" @selected($emergency_case->gender == 'female')>Female
                                                                </option>
                                                                <option value="not_mentioned"
                                                                    @selected($emergency_case->gender == 'not_mentioned')>Prefer not to say</option>
                                                            </select>
                                                            <div>
                                                                @error('gender')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>



                                                </div>

                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Emergency
                                                                contact person name</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01"
                                                                name="person_name_to_contact_incase_of_emergency"
                                                                placeholder="Enter emergency contact name"
                                                                value="{{ $emergency_case->person_name_to_contact_incase_of_emergency }}">
                                                            <div>
                                                                @error('person_name_to_contact_incase_of_emergency')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Emergency
                                                                contact person
                                                                email</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01"
                                                                name="person_email_to_contact_incase_of_emergency"
                                                                placeholder="Enter emergency contact email"
                                                                value="{{ $emergency_case->person_email_to_contact_incase_of_emergency }}">
                                                            <div>
                                                                @error('person_email_to_contact_incase_of_emergency')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Emergency
                                                                contact person
                                                                phone number</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01"
                                                                name="person_phone_to_contact_incase_of_emergency"
                                                                placeholder="Enter emergency phone number"
                                                                value="{{ $emergency_case->person_phone_to_contact_incase_of_emergency }}">
                                                            <div>
                                                                @error('person_phone_to_contact_incase_of_emergency')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>



                                                </div>

                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Details of LGBT+ rights activities involved in including
                                                                organizations and
                                                                dates worked for and the duration (Kindly add online links
                                                                where possible
                                                                for verification purposes):
                                                            </label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="activities_done"
                                                                placeholder="Enter  Details of LGBT+ rights activities involved in"
                                                                value="{{ $emergency_case->activities_done }}">
                                                            <div>
                                                                @error('activities_done')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>


                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                What happened? (Details of the threats/incidents
                                                                received and from whom including dates):
                                                            </label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="what_happened"
                                                                placeholder="Enter what happened"
                                                                value="{{ $emergency_case->what_happened }}">
                                                            <div>
                                                                @error('what_happened')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                When did it happen:
                                                            </label>
                                                            <input type="date" class="form-control"
                                                                id="validationCustom01" name="when_it_happened"
                                                                placeholder="Enter when it happened"
                                                                value="{{ $emergency_case->when_it_happened }}">
                                                            <div>
                                                                @error('when_it_happened')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Where did it happen:
                                                            </label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="where_it_happened"
                                                                placeholder="Enter where it happened"
                                                                value="{{ $emergency_case->where_it_happened }}">
                                                            <div>
                                                                @error('where_it_happened')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>



                                                </div>

                                                <div class="row">

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Why did it happen:
                                                            </label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="why_it_happened"
                                                                placeholder="Enter why it happened"
                                                                value="{{ $emergency_case->why_it_happened }}">
                                                            <div>
                                                                @error('why_it_happened')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>



                                                </div>

                                                <div class="row">

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                What specific support does the victim need?:
                                                            </label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="support_needed"
                                                                placeholder="Enter support needed"
                                                                value="{{ $emergency_case->support_needed }}">
                                                            <div>
                                                                @error('support_needed')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>



                                                </div>

                                                <div class="row">

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                What can we do as UMSC?
                                                            </label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="what_can_we_do"
                                                                placeholder="Enter what we can do as UMSC ?"
                                                                value="{{ $emergency_case->what_can_we_do }}">
                                                            <div>
                                                                @error('what_can_we_do')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row">

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Please include a tentative, detailed budget for emergency
                                                                support:
                                                            </label>

                                                            <textarea class="form-control" name="budget" id="exampleFormControlTextarea5" placeholder="Enter budget"
                                                                rows="5">{{ $emergency_case->budget }}</textarea>

                                                            <div>
                                                                @error('budget')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row">

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                What is your sustainability plan for the support you may
                                                                receive?

                                                            </label>
                                                            <textarea class="form-control" name="sustainability_plan" id="exampleFormControlTextarea5"
                                                                placeholder="Enter sustainability plan" rows="5">{{ $emergency_case->sustainability_plan }}</textarea>

                                                            <div>
                                                                @error('sustainability_plan')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                <div class="row">
                                                    <h5>Are there at least TWO or more people we may contact for more
                                                        information? (Name,
                                                        Phone number, Email address)
                                                    </h5>

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Secondary person contact name (optional)
                                                            </label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="secondary_person_name"
                                                                placeholder="optional"
                                                                value="{{ $emergency_case->secondary_person_name }}">
                                                            <div>
                                                                @error('secondary_person_name')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Secondary person contact email (optional)
                                                            </label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="secondary_person_email"
                                                                placeholder="Enter Secondary person contact email (optional)"
                                                                value="{{ $emergency_case->secondary_person_email }}">
                                                            <div>
                                                                @error('secondary_person_email')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Secondary person contact phone (optional)
                                                            </label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="secondary_person_phone"
                                                                placeholder="Enter Secondary person contact phone (optional)"
                                                                value="{{ $emergency_case->secondary_person_phone }}">
                                                            <div>
                                                                @error('secondary_person_phone')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <h5>
                                                        Photographic or Any Kind Of Evidence (If Any, Attach)

                                                    </h5>

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Enter evidence information (optional)
                                                            </label>
                                                            <textarea class="form-control" name="written_evidence" id="exampleFormControlTextarea5"
                                                                placeholder="Enter evidence information (optional)" rows="3">
                                                               {{ $emergency_case->written_evidence }}
                                                            </textarea>

                                                            <div>
                                                                @error('written_evidence')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom05">Upload
                                                                Photo evidence 1
                                                                (optional)
                                                            </label>
                                                            <input type="file" class="form-control"
                                                                name="photo_evidence_one" id="validationCustom05"
                                                                placeholder="Zip">
                                                            <div>
                                                                @error('photo_evidence_one')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>

                                                        </div>
                                                    </div>

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom05">Upload
                                                                Photo evidence 2
                                                                (optional)</label>
                                                            <input type="file" class="form-control"
                                                                name="photo_evidence_two" id="validationCustom05"
                                                                placeholder="Zip">
                                                            <div>
                                                                @error('photo_evidence_two')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>

                                                        </div>
                                                    </div>

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom05">Upload
                                                                Photo evidence 3
                                                                (optional)</label>
                                                            <input type="file" class="form-control"
                                                                name="photo_evidence_three" id="validationCustom05"
                                                                placeholder="Zip">
                                                            <div>
                                                                @error('photo_evidence_three')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>

                                                        </div>
                                                    </div>

                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom05">Upload
                                                                Photo evidence 4
                                                                (optional)</label>
                                                            <input type="file" class="form-control"
                                                                name="photo_evidence_four" id="validationCustom05"
                                                                placeholder="Zip">
                                                            <div>
                                                                @error('photo_evidence_four')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>

                                                        </div>
                                                    </div>



                                                </div>

                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="validationCustom01">
                                                            Is there any other information that you would like us to know?
                                                            (optional)
                                                        </label>
                                                        <textarea class="form-control" name="any_other_information" id="exampleFormControlTextarea5"
                                                            placeholder="Any other information" rows="3"> {{ $emergency_case->any_other_information }}</textarea>

                                                        <div>
                                                            @error('any_other_information')
                                                                <small class="text-danger"> {{ $message }}</small>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="validationCustom01">
                                                            Comment on case
                                                        </label>
                                                        <textarea class="form-control" name="comment_on_case" id="exampleFormControlTextarea5"
                                                            placeholder="Any other information" rows="3">{{ $emergency_case->comment_on_case }}</textarea>

                                                        <div>
                                                            @error('comment_on_case')
                                                                <small class="text-danger"> {{ $message }}</small>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                </div>

                                                {{-- END FORM --}}


                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">Close</button>
                                                    <!-- <button  type="submit" class="btn btn-primary">Submit</button> -->
                                                    <button class="btn btn-primary" type="submit">Update
                                                        emergency case</button>
                                                </div>


                                            </form>
                                        </div>


                                    </div>
                                </div>
                            </div>
                            {{-- END UPDATE post emergency_case --}}

                        @empty
                            <center>
                                <span class="badge bg-soft-danger text-danger"
                                    style="padding:10px;  font-size:20px;">Oops! No emergency cases available!</span>
                            </center>
                        @endforelse

                    </tbody>
                </table>
                <!-- end table -->
            </div>
            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->


    </div>
    <!-- container-fluid -->
    </div>
@endsection
