@extends('backend.layouts_backend.master')

@section('title')
    All acknowledgments reports data
@endsection

@section('content')
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">
                            All acknowledgments reports data

                            <span
                                class="text-muted fw-normal ms-2">({{ $count_acknowledgments }})</span></h5>
                    </div>
                </div>


                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">


                        {{-- @can('acknowledgement-create')
                        <div>
                            <a href="/acknowledgments/create" class="btn bg-primary text-light"><i
                                    class="bx bx-plus me-1"></i> Add
                                Acknowledgment </a>
                        </div>
                        @endcan --}}


                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH acknowledgmentS -->
            {{--  MESSAGES --}}
            <!-- FETCH FEEDBACKS -->
            {{-- alert add item --}}
            @if (session('messagesave'))
                {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagesave') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert delete item --}}
            @if (session('messagedelete'))
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    {{ session('messagedelete') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                {{-- <div class="alert alert-danger" > {{ session('messagedelete')}} </div> --}}
            @endif

            {{-- alert update item --}}
            @if (session('messageupdate'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messageupdate') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif




            <div class="table-responsive mb-4">
                <table class="table align-middle datatable dt-responsive table-check nowrap"
                    style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                    <thead>
                        <tr>

                            <th scope="col">#ID</th>
                            <th scope="col">Payment date</th>
                            <th scope="col">Recipient name</th>
                            <th scope="col">Amount</th>
                            <th style="width: 150px; min-width: 80px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        @forelse ($acknowledgments as $acknowledgment)
                            <tr>

                                <td>{{ $acknowledgment->id }}</td>
                                <td>
                                    @if (!empty($acknowledgment->payment_date))
                                        {{ $acknowledgment->payment_date }}
                                    @else
                                        <button class="btn btn-danger shadow btn-xs sharp">
                                            <span class="fa fa-exclamation-circle"> No Date</span>
                                        </button>
                                    @endif
                                </td>

                                <td>
                                    @if (!empty($acknowledgment->tenant_r->fullname))
                                        {{ $acknowledgment->tenant_r->fullname }}
                                    @else
                                        <button class="btn btn-danger shadow btn-xs sharp">
                                            <span class="fa fa-exclamation-circle"> No Tenant</span>
                                        </button>
                                    @endif
                                </td>

                                <td>
                                    @if (!empty($acknowledgment->amount_in_figures))
                                        {{ $acknowledgment->amount_in_figures }}
                                    @else
                                        <button class="btn btn-danger shadow btn-xs sharp">
                                            <span class="fa fa-exclamation-circle"> No amount</span>
                                        </button>
                                    @endif
                                </td>


                                <td colspan="6">
                                    <div class="row">

                                        @can('acknowledgement-list')
                                        <div class="col-md-4">
                                            <button type="button" class="btn btn-success" data-bs-toggle="modal"
                                                data-bs-target="#viewacknowledgmentDetails{{ $acknowledgment->id }}"
                                                data-bs-whatever="@getbootstrap"><i class=" far fa-eye  "></i></button>
                                        </div>
                                        @endcan

                                        @can('report-download')
                                        <div class="col-md-4">
                                            <a href="/acknowledgments_report/{{ $acknowledgment->id }}" target="_blank"><button
                                                    type="button" class="btn btn-secondary">
                                                    <i class="bx bx-download label-icon "></i>
                                                </button>
                                            </a>
                                        </div>
                                        @endcan


                                        {{-- @can('acknowledgement-edit')
                                        <div class="col-md-4">
                                            <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                data-bs-target="#editacknowledgment{{ $acknowledgment->id }}"
                                                data-bs-whatever="@getbootstrap"><i class="fas fa-pencil-alt "></i></button>

                                        </div>
                                        @endcan --}}

                                        <!-- delete food menu -->

                                        {{-- @can('acknowledgement-delete')
                                        <div class="col-md-4">
                                            <form action="{{ route('acknowledgments.update', $acknowledgment->id) }}"
                                                method="post">
                                                @csrf
                                                @method('DELETE')
                                                <a> <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                            class="fa fa-trash"> </button> </a>

                                            </form>
                                        </div>
                                        @endcan --}}

                                    </div>
                                </td>
                            </tr>

                            <!-- VIEW DETAILS MODEL -->
                            <div class="modal fade" id="viewacknowledgmentDetails{{ $acknowledgment->id }}" tabindex="-1"
                                aria-labelledby="viewacknowledgmentDetailsLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewacknowledgmentDetailsLabel">
                                                Acknowlegement Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>



                                        <div class="modal-body">


                                            <b>
                                                <p style="font-size: 20px;"> Payment date:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($acknowledgment->payment_date))
                                                    {{ $acknowledgment->payment_date }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No payment</button>
                                                @endif
                                            </p>
                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Recipient name:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($acknowledgment->tenant_r->fullname))
                                                    {{ $acknowledgment->tenant_r->fullname }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No Tenant</span>
                                                    </button>
                                                @endif
                                            </p>
                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Address:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($acknowledgment->address))
                                                    {{ $acknowledgment->address }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No address</button>
                                                @endif
                                            </p>
                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Amount in figures:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($acknowledgment->amount_in_figures))
                                                    {{ $acknowledgment->amount_in_figures }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No amount</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Amount in words:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($acknowledgment->amount_in_words))
                                                    {{ $acknowledgment->amount_in_words }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No amount</button>
                                                @endif
                                            </p>


                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Payment of:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($acknowledgment->payment_of))
                                                    {{ $acknowledgment->payment_of }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No payment of</button>
                                                @endif
                                            </p>


                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;">Paid by:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($acknowledgment->paid_by))
                                                    {{ $acknowledgment->paid_by }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No paid by</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Payment method:</p>
                                            </b>
                                            <p style="font-size: 20px;">
                                                @if (!empty($acknowledgment->payment_method))
                                                    {{ $acknowledgment->payment_method }}
                                                @else
                                                    <button class="btn btn-danger shadow btn-xs sharp">
                                                        <span class="fa fa-exclamation-circle"> No method</button>
                                                @endif
                                            </p>

                                            <hr>

                                            <b>
                                                <p style="font-size: 20px;"> Signature:</p>
                                            </b>

                                            @if ($acknowledgment->recipient_signature)
                                                <a href="{!! asset($acknowledgment->recipient_signature) !!}">
                                                    <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/users/avatar-2.jpg') }}') this.src = '{{ asset('assets/backend_assets/assets/images/users/avatar-2.jpg') }}';"
                                                        src="{{ asset($acknowledgment->recipient_signature) }}"
                                                        alt="preview" style=" width:100% !important; object-fit:cover;">
                                                </a>
                                            @else
                                                <p class="text-danger">No signature</p>
                                            @endif




                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close
                                            </button>

                                            @can('acknowledgement-edit')
                                            <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                data-bs-target="#editacknowledgment{{ $acknowledgment->id }}"
                                                data-bs-whatever="@getbootstrap">Edit Acknowledgment case
                                            </button>
                                            @endcan

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- END OF VIEW DETAILS MODEL -->


                            {{-- UPDATE post acknowledgment --}}
                            <div class="modal fade" id="editacknowledgment{{ $acknowledgment->id }}" tabindex="-1"
                                aria-labelledby="editacknowledgmentLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewacknowledgmentDetailsLabel">Edit
                                                Acknowledgment </h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">


                                            <!-- UPDATE post CATEGORIES -->

                                            <form action="{{ route('acknowledgments.update', $acknowledgment->id) }}"
                                                method="post" enctype="multipart/form-data">
                                                @csrf
                                                @method('PATCH')


                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Payment
                                                                date</label>
                                                            <input type="date" class="form-control"
                                                                id="validationCustom01" name="payment_date"
                                                                placeholder="Enter payment date"
                                                                value="{{ $acknowledgment->payment_date }}">
                                                            <div>
                                                                @error('payment_date')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Recipient
                                                                name (Tenant)</label>
                                                            <select name="tenant_id" class="form-select">
                                                                @foreach ($tenants as $tenant)
                                                                    <option value="{{ $tenant->id }}">
                                                                        {{ $tenant->fullname }}</option>
                                                                @endforeach
                                                            </select>
                                                            <div>
                                                                @error('tenant_id')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label"
                                                                for="validationCustom01">Address</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="address"
                                                                placeholder="Enter address"
                                                                value="{{ $acknowledgment->address }}">
                                                            <div>
                                                                @error('address')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Amount in
                                                                figures</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="amount_in_figures"
                                                                placeholder="Enter amount in figures"
                                                                value="{{ $acknowledgment->amount_in_figures }}">
                                                            <div>
                                                                @error('amount_in_figures')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Amount in
                                                                words</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="amount_in_words"
                                                                placeholder="Enter amount in words"
                                                                value="{{ $acknowledgment->amount_in_words }}">
                                                            <div>
                                                                @error('amount_in_words')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Payment
                                                                of</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="payment_of"
                                                                placeholder="Enter payment of"
                                                                value="{{ $acknowledgment->payment_of }}">
                                                            <div>
                                                                @error('payment_of')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">
                                                                Acknowledged by (Admin)</label>
                                                            <input type="text" class="form-control"
                                                                id="validationCustom01" name="paid_by"
                                                                style="pointer-events: none"
                                                                value="{{ $acknowledgment->paid_by }}">
                                                            <div>
                                                                @error('paid_by')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Payment
                                                                method</label>
                                                            <select name="payment_method" class="form-select">
                                                                <option value="airtel_money">Airtel money</option>
                                                                <option value="mtn_mobile_money">Mtn mobile money</option>
                                                                <option value="bank">Bank Transfer</option>
                                                                <option value="card_transaction">Visa cards / Master card
                                                                </option>
                                                                <option value="cryptocurrency">Cryptocurrency</option>
                                                                <option value="cryptocurrency">Western Union</option>
                                                            </select>
                                                            <div>
                                                                @error('payment_method')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>



                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="validationCustom01">Recipient
                                                                signature</label>
                                                            <input type="file" class="form-control"
                                                                id="validationCustom01" name="recipient_signature"
                                                                value="">
                                                            <div>
                                                                @error('recipient_signature')
                                                                    <small class="text-danger"> {{ $message }}</small>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>


                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">Close</button>
                                                    <!-- <button  type="submit" class="btn btn-primary">Submit</button> -->
                                                    <button class="btn btn-primary" type="submit">Update
                                                        acknowledgment</button>
                                                </div>


                                            </form>
                                        </div>


                                    </div>
                                </div>
                            </div>
                            {{-- END UPDATE post acknowledgment --}}

                        @empty
                            <center>
                                <span class="badge bg-soft-danger text-danger"
                                    style="padding:10px;  font-size:20px;">Oops! No acknowledgments available!</span>
                            </center>
                        @endforelse

                    </tbody>
                </table>
                <!-- end table -->
            </div>
            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->












    </div>
    <!-- container-fluid -->
    </div>
@endsection
