@extends('backend.layouts_backend.master')

@section('title')
    Dashboard
@endsection
@section('content')
    <!-- Main content dashboard  -->
    <div class="page-content">
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">Dashboard</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                                <li class="breadcrumb-item active">Home</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            

            {{-- start of dashboard counter statistics --}}

            @can('dashboard-counter-statistics')
            {{-- DASHBOARD ROW --}}

            <div class="row">
                <div class="col-xl-3 col-md-6">
                    <!-- card -->
                    <div class="card card-h-100">
                        <!-- card body -->
                        <div class="card-body bg-gradient" style="background-color:rgb(171, 13, 171);">
                            <div class="row align-items-center">
                                <div class="col-6">
                                    <span class="text-light mb-3 lh-1 d-block ">Categories</span>
                                    <h4 class="mb-3 text-light">
                                        <span class="counter-value" data-target="{{ $count_apartment_categories }}"></span>
                                    </h4>
                                </div>


                            </div>
                            <div class="text-nowrap">
                                <span class="badge bg-soft-primary text-light">{{ $count_apartment_categories }}</span>
                                <span class="ms-1 text-light font-size-13">Details</span>
                            </div>
                        </div><!-- end card body -->
                    </div><!-- end card -->
                </div><!-- end col -->

                <div class="col-xl-3 col-md-6">
                    <!-- card -->
                    <div class="card card-h-100">
                        <!-- card body -->
                        <div class="card-body bg-gradient bg-primary">
                            <div class="row align-items-center">
                                <div class="col-6">
                                    <span class="text-light mb-3 lh-1 d-block text-truncate">Amenities</span>
                                    <h4 class="mb-3 text-light">
                                        <span class="counter-value" data-target="{{ $count_amenities }}"></span>
                                    </h4>
                                </div>

                            </div>
                            <div class="text-nowrap">
                                <span class="badge bg-soft-danger text-light">{{ $count_amenities }}</span>
                                <span class="ms-1 text-light font-size-13">Details</span>
                            </div>
                        </div><!-- end card body -->
                    </div><!-- end card -->
                </div><!-- end col-->

                <div class="col-xl-3 col-md-6">
                    <!-- card -->
                    <div class="card card-h-100">
                        <!-- card body -->
                        <div class="card-body bg-gradient bg-success">
                            <div class="row align-items-center">
                                <div class="col-6">
                                    <span class="text-muted mb-3 lh-1 d-block text-truncate">Apartments</span>
                                    <h4 class="mb-3">
                                        <span class="counter-value" data-target="{{ $count_apartments }}"></span>
                                    </h4>
                                </div>

                            </div>
                            <div class="text-nowrap">
                                <span class="badge bg-soft-success text-light">{{ $count_apartments }}</span>
                                <span class="ms-1 text-light font-size-13">Details</span>
                            </div>
                        </div><!-- end card body -->
                    </div><!-- end card -->
                </div><!-- end col -->

                <div class="col-xl-3 col-md-6">
                    <!-- card -->
                    <div class="card card-h-100">
                        <!-- card body -->
                        <div class="card-body bg-gradient bg-danger">
                            <div class="row align-items-center">
                                <div class="col-6">
                                    <span class="text-muted mb-3 lh-1 d-block">Users</span>
                                    <h4 class="mb-3">
                                        <span class="counter-value" data-target="{{ $count_users }}"></span>
                                    </h4>
                                </div>

                            </div>
                            <div class="text-nowrap">
                                <span class="badge bg-soft-primary text-light">{{ $count_users }}</span>
                                <span class="ms-1 text-light font-size-13">Details</span>
                            </div>
                        </div><!-- end card body -->
                    </div><!-- end card -->
                </div><!-- end col -->
            </div>

            {{-- END OF DASHBOARD ROW --}}
            @endcan
            
           {{-- end of dashboard counter statistics --}}


           








        </div>
        <!-- container-fluid -->
    </div>
@endsection


@section('extra_scripts')
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

@endsection
