@extends('backend.layouts_backend.master')

@section('title')
    Trashed Apartments
@endsection

@section('content')
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">Trashed Apartments <span
                                class="text-muted fw-normal ms-2">({{ $count_trashed_apartments }})</span></h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        <div>
                            @can('apartment-list')
                                <a href="/admin/apartments" class="btn bg-primary text-light"><i class="bx bx-plus me-1"></i>
                                    All Apartments</a>
                            @endcan
                        </div>




                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH apartments -->
            {{--  MESSAGES --}}
            <!-- FETCH FEEDBACKS -->
            {{-- alert add item --}}
            @if (session('messagesave'))
                {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagesave') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert delete item --}}
            @if (session('messagedelete'))
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    {{ session('messagedelete') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                {{-- <div class="alert alert-danger" > {{ session('messagedelete')}} </div> --}}
            @endif

            {{-- alert update item --}}
            @if (session('messageupdate'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messageupdate') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert restore item --}}
            @if (session('messagerestore'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagerestore') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif




            <div class="table-responsive mb-4">
                <table class="table align-middle datatable dt-responsive table-check nowrap"
                    style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                    <thead>
                        <tr>

                            {{-- <th scope="col">#ID</th> --}}
                            <th scope="col"> Unique ID</th>
                            <th scope="col">Apartment Name</th>
                            <th scope="col">Category</th>
                            <th scope="col">Price</th>
                            <th scope="col">Price Range</th>
                            <th scope="col">Created By</th>
                            <th style="width: 150px; min-width: 80px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        @forelse ($trashed_apartments as $apartment)
                            <tr>

                                {{-- <td>{{ $apartment->id }}</td> --}}
                                <td>{{ $apartment->unique_id }}</td>

                                <td>
                                    @if (!empty($apartment->name))
                                        {{ $apartment->name }}
                                    @else
                                        <span>N/A</span>
                                    @endif

                                </td>

                                <td>
                                    @if (!empty($apartment->apartment_category->category_name))
                                        {{ $apartment->apartment_category->category_name }}
                                    @else
                                        <span>N/A</span>
                                    @endif

                                </td>

                                <td>
                                    @if (!empty($apartment->price))
                                        {{ $apartment->price }}
                                    @else
                                        <span>N/A</span>
                                    @endif
                                </td>

                                <td>


                                    @if (!empty($apartment->price_range))
                                        @if ($apartment->price_range == '1000_2000')
                                            {{ '1000 - 2000 ' }}
                                        @endif

                                        @if ($apartment->price_range == '2000_3000')
                                            {{ '2000 - 3000' }}
                                        @endif

                                        @if ($apartment->price_range == '3000_4000')
                                            {{ '3000 - 4000' }}
                                        @endif

                                        @if ($apartment->price_range == '4000_5000')
                                            {{ '4000 - 5000' }}
                                        @endif

                                        @if ($apartment->price_range == 'null')
                                            {{ 'N/A' }}
                                        @endif
                                    @else
                                        <span> N/A </span>
                                    @endif

                                </td>
                                <td>
                                    @if (!empty($apartment->user->name))
                                        {{ $apartment->user->name }}
                                    @else
                                        <span>N/A</span>
                                    @endif
                                </td>


                                <td colspan="6">
                                    <div class="row">

                                        <!-- delete  -->
                                        @can('apartment-restore')
                                            <div class="col-md-4">
                                                <form action="{{ route('apartments.restore', $apartment->id) }}"
                                                    method="post">
                                                    @csrf
                                                    @method('POST')
                                                    <a> <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                                class="fa fa-arrow-left"> </button> </a>
                                                </form>
                                            </div>
                                        @endcan


                                    </div>
                                </td>
                            </tr>

                            <!-- VIEW DETAILS MODEL -->
                            <div class="modal fade" id="viewapartmentDetails{{ $apartment->id }}" tabindex="-1"
                                aria-labelledby="viewapartmentDetailsLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewapartmentDetailsLabel"> Apartment
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>



                                        <div class="modal-body">

                                            {{-- featured photo --}}
                                            <p>Featured Photo </p>
                                            <hr>

                                            <a href="{!! asset($apartment->featured_photo) !!}">
                                                <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
                                                    src="{{ asset($apartment->featured_photo) }}" alt="preview"
                                                    style=" width:100% !important; object-fit:cover;">
                                            </a>
                                            <hr>

                                            <p> Property Name : {{ $apartment->name }}</p>
                                            <hr>
                                            <p> Amenities </p>
                                            <hr>
                                            <div class="row">
                                                @forelse ($apartment->amenities as $amenity)
                                                    <div class="col-lg-6">
                                                        <div class="card bg-primary border-primary text-white-50">
                                                            <div class="card-body">
                                                                <h5 class="mb-3 text-white text-center">
                                                                    {{ $amenity->name }}</h5>
                                                                {{-- <p class="card-text">Some quick example text to build on the card title and make up the bulk of the card's content.</p> --}}
                                                            </div>
                                                        </div>
                                                    </div>

                                                @empty

                                                    <span style="color:red;">No Amenities Available </span>
                                                @endforelse

                                            </div>

                                            <hr>
                                            <p>Property 3D Video </p>
                                            <div class="card-body">
                                                <!-- 16:9 aspect ratio -->
                                                <div class="ratio ratio-16x9">
                                                    {{-- <iframe src="{{ $apartment->property_video_url }}" title="YouTube video" allowfullscreen=""></iframe> --}}
                                                    <iframe width="130" height="175"
                                                        src=" {{ $apartment->property_video_url }}"
                                                        allowfullscreen="allowfullscreen"
                                                        mozallowfullscreen="mozallowfullscreen"
                                                        msallowfullscreen="msallowfullscreen"
                                                        oallowfullscreen="oallowfullscreen"
                                                        webkitallowfullscreen="webkitallowfullscreen">
                                                    </iframe>
                                                </div>
                                            </div>


                                            <hr>
                                            {{-- photo library upload --}}
                                            <div class="card" style="margin-top:20px;">
                                                <div class="card-header" style="background-color:#0e274c; color:#ffffff;">
                                                    <center>Apartment Photos Collection</center>
                                                </div>
                                                <div class="card-body">

                                                    <div class="row">

                                                        {{-- pick multiple images from array --}}
                                                        @if (!empty($apartment->photo_library))
                                                            @foreach (is_null($apartment->photo_library) ? [] : explode(',', $apartment->photo_library) as $image)
                                                                {{-- START COL --}}
                                                                <div class=" col-md-6 col-sm-6 col-xs-12">

                                                                    <a href="{!! asset($image) !!}">
                                                                        <img style="
                                                                            height: 200px; 
                                                                            background-color:#ffffff; 
                                                                            object-fit:cover;
                                                                            max-width:100% !important;
                                                                            border:#ffffff 2px solid;
                                                                            background-repeat: no-repeat;
                                                                            object-position: center center;
                                                                            background-size:cover;
                                                                            padding:7px; 
                                                                            margin:0px;"
                                                                            src="{{ asset($image) }}" alt="">
                                                                    </a>


                                                                </div>
                                                                {{-- END COL --}}
                                                            @endforeach
                                                        @else
                                                            <center><span>No Photos Available <span></center>
                                                        @endif
                                                        {{-- end pick multiple images  from array --}}


                                                    </div>


                                                </div>
                                            </div>

                                            {{-- end of photo library upload --}}



                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close
                                            </button>

                                            @can('apartment-edit')
                                                <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                    data-bs-target="#editapartment{{ $apartment->id }}"
                                                    data-bs-whatever="@getbootstrap">Edit apartment
                                                </button>
                                            @endcan

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- END OF VIEW DETAILS MODEL -->


                            {{-- UPDATE  apartment --}}
                            <div class="modal fade" id="editapartment{{ $apartment->id }}" tabindex="-1"
                                aria-labelledby="editapartmentLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewapartmentDetailsLabel">Edit apartment
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">


                                            <!-- UPDATE  CATEGORIES -->

                                            <form action="{{ route('apartments.update', $apartment->id) }}"
                                                method="post" enctype="multipart/form-data">
                                                @csrf
                                                @method('PATCH')
                                                <div class="mb-3">
                                                    <label for="recipient-name" class="col-form-label">Name:</label>
                                                    <input type="text" class="form-control" name="name"
                                                        value="{{ $apartment->name }}" id="recipient-name">
                                                </div>


                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">Close</button>
                                                    <!-- <button  type="submit" class="btn btn-primary">Submit</button> -->
                                                    <button class="btn btn-primary" type="submit">Update
                                                        apartment</button>
                                                </div>


                                            </form>
                                        </div>


                                    </div>
                                </div>
                            </div>
                            {{-- END UPDATE post apartment --}}

                        @empty
                            <center>
                                <span class="badge bg-soft-danger text-danger"
                                    style="padding:10px;  font-size:20px;">Oops! No apartments available!</span>
                            </center>
                        @endforelse

                    </tbody>
                </table>
                <!-- end table -->
            </div>
            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->












    </div>
    <!-- container-fluid -->
    </div>
@endsection
