@extends('backend.layouts_backend.master')

@section('title')
    Trashed Apartment Categories
@endsection

@section('content')
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">Apartment Categories <span
                                class="text-muted fw-normal ms-2">({{ $count_trashed_apartment_categories }})</span></h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        <div>
                            @can('apartment-category-list')
                                <a href="/admin/apartment_categories" class="btn bg-primary text-light"><i class="bx bx-plus me-1"></i>
                                    All Apartment Category</a>

                            @endcan
                        </div>

                       


                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH amenities -->
            {{--  MESSAGES --}}
            <!-- FETCH FEEDBACKS -->
            {{-- alert add item --}}
            @if (session('messagesave'))
                {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagesave') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert delete item --}}
            @if (session('messagedelete'))
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    {{ session('messagedelete') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                {{-- <div class="alert alert-danger" > {{ session('messagedelete')}} </div> --}}
            @endif

            {{-- alert update item --}}
            @if (session('messageupdate'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messageupdate') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

                {{-- alert restore item --}}
                @if (session('messagerestore'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagerestore') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif




            <div class="table-responsive mb-4">
                <table class="table align-middle datatable dt-responsive table-check nowrap"
                    style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                    <thead>
                        <tr>

                            <th scope="col">#ID</th>
                            <th scope="col">Category Name</th>
                            <th scope="col">Category Description</th>
                            <th scope="col">Created By</th>
                            <th style="width: 150px; min-width: 80px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        @forelse ($trashed_apartment_categories as $apartment_category)
                            <tr>

                                <td>{{ $apartment_category->id }}</td>
                                <td>
                                    <a href="#" class="text-body">
                                        @if(!empty($apartment_category->category_name))
                                        {{ $apartment_category->category_name }}

                                        @else
                                        <span>N/A</span>
                                        @endif
                                        
                                    </a>
                                </td>
                                <td>
                                    @if(!empty($apartment_category->category_description))
                                        {{ $apartment_category->category_description }}

                                        @else
                                        <span>N/A</span>
                                        @endif
                                </td>

                                <td>
                                    @if(!empty($apartment_category->category_description))
                                        {{ $apartment_category->user->name }}

                                        @else
                                        <span>N/A</span>
                                        @endif
                                </td>


                                <td colspan="6">
                                    <div class="row">


                                        <!-- delete  -->

                                        @can('apartment-category-restore')
                                            <div class="col-md-4">
                                                <form action="{{ route('apartment_categories.restore', $apartment_category->id) }}" method="post">
                                                    @csrf
                                                    @method('POST')
                                                    <a> <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                                class="fa fa-arrow-left"> </button> </a>

                                                </form>
                                            </div>
                                        @endcan


                                    </div>
                                </td>
                            </tr>

                            <!-- VIEW DETAILS MODEL -->
                            <div class="modal fade" id="viewapartment_categoryDetails{{ $apartment_category->id }}" tabindex="-1"
                                aria-labelledby="viewapartment_categoryDetailsLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewapartment_categoryDetailsLabel"> Category
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>



                                        <div class="modal-body">


                                            <p> Name : {{ $apartment_category->category_name }}</p>
                                            <hr>

                                            <p> Description : {{ $apartment_category->category_description }}</p>
                                            <hr>



                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close
                                            </button>

                                            @can('apartment-category-edit')
                                            <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                data-bs-target="#editapartment_category{{ $apartment_category->id }}"
                                                data-bs-whatever="@getbootstrap">Edit Category
                                            </button>
                                            @endcan

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- END OF VIEW DETAILS MODEL -->


                            {{-- UPDATE  apartment_category --}}
                            <div class="modal fade" id="editapartment_category{{ $apartment_category->id }}" tabindex="-1"
                                aria-labelledby="editapartment_categoryLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewapartment_categoryDetailsLabel">Edit Apartment Category
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">


                                            <!-- UPDATE  CATEGORIES -->

                                            <form action="{{ route('apartment_categories.update', $apartment_category->id) }}" method="post"
                                                enctype="multipart/form-data">
                                                @csrf
                                                @method('PATCH')
                                                <div class="mb-3">
                                                    <label for="recipient-name" class="col-form-label">Name:</label>
                                                    <input type="text" class="form-control" name="category_name"
                                                        value="{{ $apartment_category->category_name }}" id="recipient-name">
                                                </div>

                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="validationCustom01">Description</label>
            
                                                        <textarea class="form-control" name="category_description" id="exampleFormControlTextarea5"
                                                            placeholder="Describe the ammenity" rows="3">{{ $apartment_category->category_description }}</textarea>
                                                        <div>
                                                            @error('category_description')
                                                                <small class="text-danger"> {{ $message }}</small>
                                                            @enderror
                                                        </div>
                                                    </div>
            
                                                </div>


                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">Close</button>
                                                    <!-- <button  type="submit" class="btn btn-primary">Submit</button> -->
                                                    <button class="btn btn-primary" type="submit">Update
                                                        Category</button>
                                                </div>


                                            </form>
                                        </div>


                                    </div>
                                </div>
                            </div>
                            {{-- END UPDATE  --}}

                        @empty
                            <center>
                                <span class="badge bg-soft-danger text-danger"
                                    style="padding:10px;  font-size:20px;">Oops! No category available!</span>
                            </center>
                        @endforelse

                    </tbody>
                </table>
                <!-- end table -->
            </div>
            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->












    </div>
    <!-- container-fluid -->
    </div>
@endsection
