@extends('backend.layouts_backend.master')

@section('title')
    All Ammenities
@endsection

@section('content')
    <!-- Main content dashboard  -->



    <div class="page-content">
        <div class="container-fluid">



            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <h5 class="card-title">Amenities <span
                                class="text-muted fw-normal ms-2">({{ $count_amenities }})</span></h5>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="d-flex flex-wrap align-items-center justify-content-end gap-2 mb-3">

                        <div>
                            @can('amenity-create')
                                <a href="/admin/amenities/create" class="btn bg-primary text-light"><i class="bx bx-plus me-1"></i>
                                    Add amenity</a>

                            @endcan
                        </div>

                        <div>
                            @can('amenity-restore')
                                <a href="/admin/trashed_amenities" class="btn bg-danger text-light"><i class="bx bx-plus me-1"></i>
                                    Trashed Amenities</a>

                            @endcan
                        </div>


                    </div>

                </div>
            </div>
            <!-- end row -->





            <!-- FETCH amenities -->
            {{--  MESSAGES --}}
            <!-- FETCH FEEDBACKS -->
            {{-- alert add item --}}
            @if (session('messagesave'))
                {{-- <div class="alert alert-success" > {{ session('message')}} </div> --}}
                <div class="alert alert-success alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagesave') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- alert delete item --}}
            @if (session('messagedelete'))
                <div class="alert alert-danger alert-dismissible alert-label-icon label-arrow fade show" role="alert">
                    <i class="mdi mdi-block-helper label-icon"></i>
                    {{ session('messagedelete') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                {{-- <div class="alert alert-danger" > {{ session('messagedelete')}} </div> --}}
            @endif

            {{-- alert update item --}}
            @if (session('messageupdate'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messageupdate') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

                {{-- alert restore item --}}
                @if (session('messagerestore'))
                <div class="alert alert-info alert-dismissible alert-label-icon label-arrow fade show mb-0" role="alert">
                    <i class="mdi mdi-check-all label-icon"></i>
                    {{ session('messagerestore') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif




            <div class="table-responsive mb-4">
                <table class="table align-middle datatable dt-responsive table-check nowrap"
                    style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                    <thead>
                        <tr>

                            <th scope="col">#ID</th>
                            <th scope="col">Amenity Name</th>
                            <th scope="col">Created By</th>
                            <th style="width: 150px; min-width: 80px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        @forelse ($amenities as $amenity)
                            <tr>

                                <td>{{ $amenity->id }}</td>
                                <td>
                                    <a href="#" class="text-body">
                                        @if(!empty($amenity->name))
                                        {{ $amenity->name }}

                                        @else
                                        <span>N/A</span>
                                        @endif
                                        
                                    </a>
                                </td>
                                <td>
                                    @if(!empty($amenity->user->name))
                                        {{ $amenity->user->name }}

                                        @else
                                        <span>N/A</span>
                                        @endif
                                </td>


                                <td colspan="6">
                                    <div class="row">

                                        @can('amenity-show')
                                        <div class="col-md-4">
                                            <button type="button" class="btn btn-success" data-bs-toggle="modal"
                                                data-bs-target="#viewamenityDetails{{ $amenity->id }}"
                                                data-bs-whatever="@getbootstrap"><i class=" far fa-eye  "></i></button>
                                        </div>
                                        @endcan

                                        {{-- edit --}}
                                        @can('amenity-edit')
                                            <div class="col-md-4">
                                                <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                    data-bs-target="#editamenity{{ $amenity->id }}"
                                                    data-bs-whatever="@getbootstrap"><i class="fas fa-pencil-alt "></i></button>

                                            </div>
                                        @endcan

                                        <!-- delete  -->

                                        @can('amenity-delete')
                                            <div class="col-md-4">
                                                <form action="{{ route('amenities.destroy', $amenity->id) }}" method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <a> <button class="btn btn-danger shadow btn-xs sharp"> <span
                                                                class="fa fa-trash"> </button> </a>

                                                </form>
                                            </div>
                                        @endcan


                                    </div>
                                </td>
                            </tr>

                            <!-- VIEW DETAILS MODEL -->
                            <div class="modal fade" id="viewamenityDetails{{ $amenity->id }}" tabindex="-1"
                                aria-labelledby="viewamenityDetailsLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewamenityDetailsLabel"> Amenity
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>



                                        <div class="modal-body">


                                            <p> Name : {{ $amenity->name }}</p>
                                            <hr>



                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close
                                            </button>

                                            @can('amenity-edit')
                                            <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                data-bs-target="#editamenity{{ $amenity->id }}"
                                                data-bs-whatever="@getbootstrap">Edit amenity
                                            </button>
                                            @endcan

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- END OF VIEW DETAILS MODEL -->


                            {{-- UPDATE  amenity --}}
                            <div class="modal fade" id="editamenity{{ $amenity->id }}" tabindex="-1"
                                aria-labelledby="editamenityLabel" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="viewamenityDetailsLabel">Edit Amenity
                                                Details</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">


                                            <!-- UPDATE  CATEGORIES -->

                                            <form action="{{ route('amenities.update', $amenity->id) }}" method="post"
                                                enctype="multipart/form-data">
                                                @csrf
                                                @method('PATCH')
                                                <div class="mb-3">
                                                    <label for="recipient-name" class="col-form-label">Name:</label>
                                                    <input type="text" class="form-control" name="name"
                                                        value="{{ $amenity->name }}" id="recipient-name">
                                                </div>


                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">Close</button>
                                                    <!-- <button  type="submit" class="btn btn-primary">Submit</button> -->
                                                    <button class="btn btn-primary" type="submit">Update
                                                        Amenity</button>
                                                </div>


                                            </form>
                                        </div>


                                    </div>
                                </div>
                            </div>
                            {{-- END UPDATE post amenity --}}

                        @empty
                            <center>
                                <span class="badge bg-soft-danger text-danger"
                                    style="padding:10px;  font-size:20px;">Oops! No amenities available!</span>
                            </center>
                        @endforelse

                    </tbody>
                </table>
                <!-- end table -->
            </div>
            <!-- end table responsive -->

        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->












    </div>
    <!-- container-fluid -->
    </div>
@endsection
