<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('apartment_proximities', function (Blueprint $table) {
            $table->id();
            $table->string('place_category')->nullable();
            $table->text('name')->nullable();
            $table->string('distance')->nullable();
            $table->string('time')->nullable();
            $table->text('address')->nullable();
            $table->foreignId('apartment_id')->constrained('apartments');
            $table->foreignId('created_by')->constrained('users');
            $table->foreignId('updated_by')->nullable()->constrained('users');
            $table->softDeletes();
            $table->timestamps();        
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('apartment_proximities');
    }
};
