<?php

namespace App\Providers;

use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;

// observers
use App\Observers\AmmenityObserver;
use App\Observers\ApartmentCategoryObserver;
use App\Observers\ApartmentObserver;

// models
use App\Models\Amenity;
use App\Models\ApartmentCategory;
use App\Models\Apartment;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event to listener mappings for the application.
     *
     * @var array<class-string, array<int, class-string>>
     */
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        // ammentity observer
        Amenity::observe(AmmenityObserver::class);
        // apartment category observer
        ApartmentCategory::observe(ApartmentCategoryObserver::class);
        // apartment observer
        Apartment::observe(ApartmentObserver::class);

    }

    /**
     * Determine if events and listeners should be automatically discovered.
     *
     * @return bool
     */
    public function shouldDiscoverEvents()
    {
        return false;
    }
}
