<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Haruncpi\LaravelUserActivity\Traits\Loggable;

class ApartmentProximity extends Model
{
    use HasFactory,SoftDeletes, Loggable;
    protected $dates = ['deleted_at'];

    
    public function user(){
        return $this->belongsTo(User::class,'created_by');
    }

    // apartment proximity belongs to tour category
    public function apartment()
    {
        // foreign key // local key
        return $this->belongsTo(Apartment::class,'apartment_id','id');
    }
}
