<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
// login activity
use Haruncpi\LaravelUserActivity\Traits\Loggable;


class ApartmentCategory extends Model
{
  
    use HasFactory,SoftDeletes, Loggable;
    protected $dates = ['deleted_at'];

    // apartment belongs to a user
    public function user(){
        return $this->belongsTo(User::class,'created_by');
    }

    // apartment category has many apartments
    public function apartments()
    {
        // foreignkey //localkey
        return $this->hasMany(Apartment::class, 'apartment_category_id', 'id');
    }
    

}
