<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
// login activity
use Haruncpi\LaravelUserActivity\Traits\Loggable;


class Amenity extends Model
{
    use HasFactory,SoftDeletes;
    protected $dates = ['deleted_at'];


    public function user(){
        return $this->belongsTo(User::class,'created_by');
   
      }

    // many to many relationship with amenity
    public function apartments()
    {
        return $this->belongsToMany(Apartment::class);
    }
}
