<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class ApartmentBookingEmailNotification extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */

    //  global varaible to pick data from booking form
    public $booking_data;

    public function __construct($booking_data)
    {
        $this->booking_data = $booking_data;
    }

    /**
     * Get the message envelope.
     *
     * @return \Illuminate\Mail\Mailables\Envelope
     */

    public function build()
    {
        return $this->subject('New Apartment Booking from Relocacate Portal')
            ->view('frontend.pages_frontend.emails.book_apartment_notification')
            ->with('booking_data', $this->booking_data);
    }
    // public function envelope()
    // {
    //     return new Envelope(
    //         subject: 'Apartment Booking Email Notification',
    //     );
    // }

    // /**
    //  * Get the message content definition.
    //  *
    //  * @return \Illuminate\Mail\Mailables\Content
    //  */
    // public function content()
    // {
    //     return new Content(
    //         view: 'frontend.pages_frontend.emails.book_apartment_notification',
    //     );
    // }

    // /**
    //  * Get the attachments for the message.
    //  *
    //  * @return array
    //  */
    // public function attachments()
    // {
    //     return [];
    // }
}
