<?php

namespace App\Http\Requests\Users;

use Illuminate\Foundation\Http\FormRequest;

class StoreUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|same:confirm-password',
            'roles' => 'required'
        ];
    }

     // custom messages
     public function messages(): array
     {
         return [
             'name.required'  => 'Please enter the user name',
             'email.required' => 'Please enter user email',
             'email.unique'   => 'This email already exists!',
             'roles.required' => 'You forgot to assign roles to the user'
            //  'description' => 'nullable'
             
         ];
     }
}
