<?php

namespace App\Http\Requests\Bookings;

use Illuminate\Foundation\Http\FormRequest;

class StoreBookingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'first_name' => 'required',
            'last_name' => 'required',
            'email' => 'required',
            'nationality' => 'required',
            'current_address' => 'nullable',
            'phone_number' => 'nullable',
            'arrival_date' => 'nullable',
            'departure_date' => 'nullable',
            'message' => 'nullable',
            'created_by' => 'nullable',
            'apartment_id' => 'required',
        ];
    }

     // custom messages
     public function messages(): array
     {
         return [
             'first_name.required' => 'Enter first name',
             'last_name.required' => 'Enter last name',
             'email.required' => 'You missed an email',
             'nationality.required' => 'Enter nationality',
             'apartment_id.required' => 'Apartment not identified',
         ];
     }
}
