<?php

namespace App\Http\Requests\ApartmentCategories;

use Illuminate\Foundation\Http\FormRequest;

class StoreApartmentCategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'category_name' => 'required',
            'category_description' => 'nullable',
        ];
    }

     // custom messages
     public function messages(): array
     {
         return [
             'category_name.required' => 'Please enter the category name',
             'category_description' => 'nullable',
            //  'description' => 'nullable'
             
         ];
     }
}
