<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;



class CheckRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */

     public function handle($request, Closure $next, ...$roles)
     {
         $user = Auth::user();
     
         if ($user->hasRole($roles)) {
             // User has one of the specified roles
            //  auth::user()->getRoleNames()->first()
             switch ($user->getRoleNames()->first()) {
                 case 'buyer':
                     if ($request->routeIs('relocate_apartments.index')) {
                         return $next($request);
                     } else {
                         return redirect()->route('relocate_apartments.index');
                     }
                 case 'Admin':
                     if ($request->routeIs('dashboard.index')) {
                         return $next($request);
                     } else {
                         return redirect()->route('dashboard.index');
                     }
                 // Add more cases for other roles as needed
             }
         }
     
         return $next($request);
     }
}
