<?php

namespace App\Http\Controllers\FrontEnd\TourBookings;

use App\Http\Controllers\Controller;
use App\Models\TourBooking;
use Illuminate\Http\Request;
use App\Models\Tour;
use App\Mail\AdminTourBookingNotification;
use App\Mail\CustomerTourBookingNotification;
use Illuminate\Support\Facades\Mail;



class FrontEndTourBookingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return "tour bookings";
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $tour_booking = new TourBooking();
        $tour_booking->first_name = $request->first_name;
        $tour_booking->last_name = $request->last_name;
        $tour_booking->email = $request->email;
        $tour_booking->nationality = $request->nationality;
        $tour_booking->current_address = $request->current_address;
        $tour_booking->phone_number = $request->phone_number;
        $tour_booking->arrival_date = $request->arrival_date;
        $tour_booking->departure_date = $request->departure_date;
        $tour_booking->message = $request->message;
        $tour_booking->tour_id = $request->tour_id;
        $tour_booking->created_by = auth()->user()->id;


        // dd($tour_booking->toArray());

        // // pick a list of admin emails here from db table
        $admin_reciever_mail_list = ['wandieinnocent2@gmail.com'];

        // // send email to user/customer
        Mail::to($tour_booking->email)->send(new CustomerTourBookingNotification($tour_booking));

        // // send mail to admin
        Mail::to($admin_reciever_mail_list)->send(new AdminTourBookingNotification($tour_booking));



        // check for units availale
        $slots_available = $tour_booking->tour->slots_available;

        if ($slots_available <= 0) {
            // dd("u have tour slots");
            return redirect()->back()->with("messagenoapartments", "This Tour does not have any more units to book.");
        }

        if ($slots_available > 0) {
            $current_tour = Tour::find($tour_booking->tour_id);
            $current_tour->slots_available -= 1;
            // store_tour_with_decremented_value
            $current_tour->save();

            // store booking and decrement tour unit
            $tour_booking->save();
            return redirect()->back()->with("messagesave", "This Tour has been booked  Successfuly, you are going to be contacted by our team soon.");


        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
