<?php

namespace App\Http\Controllers\FrontEnd\Bookings;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Booking;
use App\Models\Apartment;
use App\Http\Requests\Bookings\StoreBookingRequest;
use Illuminate\Support\Facades\Mail;
use App\Mail\ApartmentBookingEmailNotification;
use App\Mail\UserApartmentBookingNotification;



class FrontEndBookingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return "booking";
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreBookingRequest $request)
    {

        $booking = new Booking();
        $booking->first_name = $request->first_name;
        $booking->last_name = $request->last_name;
        $booking->email = $request->email;
        $booking->nationality = $request->nationality;
        $booking->current_address = $request->current_address;
        $booking->phone_number = $request->phone_number;
        $booking->arrival_date = $request->arrival_date;
        $booking->departure_date = $request->departure_date;
        $booking->message = $request->message;
        $booking->apartment_id = $request->apartment_id;
        $booking->created_by = auth()->user()->id;


        // dd($units_available);

        // pick a list of admin emails here from db table
        $admin_reciever_mail_list = ['wandieinnocent2@gmail.com'];

        // send email to user
        Mail::to($booking->email)->send(new UserApartmentBookingNotification($booking));

        // send mail to admin
        Mail::to($admin_reciever_mail_list)->send(new ApartmentBookingEmailNotification($booking));

        // check for units availale
        $units_available = $booking->apartment->units_available;

        if ($units_available <= 0) {
            // dd("u have apartments units");
            return redirect()->back()->with("messagenoapartments", "This Apartment does not have any more units to book.");
        }

        if ($units_available > 0) {
            $current_apartment = Apartment::find($booking->apartment_id);
            $current_apartment->units_available -= 1;
            // store_apartment_with_decremented_value
            $current_apartment->save();

            // store booking and decrement apartment unit
            $booking->save();
            return redirect()->back()->with("messagesave", "This Apartment has been booked  Successfuly, you are going to be contacted by our team soon.");


        }


        // $booking->save();

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
