<?php

namespace App\Http\Controllers\FrontEnd\Apartments;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Apartment;
use Auth;


class FrontEndApartmentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // display apartments based on user roles and pricing
        $userRole = auth::user()->getRoleNames()->first();
        // dd($userRole);

        $apartments = [];
        if ($userRole == 'Admin') {
            $apartments = Apartment::with('amenities')->orderBy('price', 'desc')->get();
        } else if ($userRole == '1000_2000') {
            $apartments = Apartment::with('amenities')
                ->whereBetween('price', ['1000', '2000'])
                ->orderBy('price', 'desc')->get();
        } else if ($userRole == '2000_3000') {
            $apartments = Apartment::with('amenities')
                ->whereBetween('price', ['1000', '3000'])
                ->orderBy('price', 'desc')->get();
        } else if ($userRole == '3000_4000') {
            $apartments = Apartment::with('amenities')
                ->whereBetween('price', ['1000', '4000'])
                ->orderBy('price', 'desc')->get();
        } else if ($userRole == '4000_5000') {
            $apartments = Apartment::with('amenities')
                ->whereBetween('price', ['1000', '5000'])
                ->orderBy('price', 'desc')->get();
        } else if ($userRole == '5000_6000') {
            $apartments = Apartment::with('amenities')
                ->whereBetween('price', ['1000', '6000'])
                ->orderBy('price', 'desc')->get();
        } else if ($userRole == '6000_7000') {
            $apartments = Apartment::with('amenities')
                ->whereBetween('price', ['1000', '7000'])
                ->orderBy('price', 'desc')->get();
        } else if ($userRole == '7000_8000') {
            $apartments = Apartment::with('amenities')
                ->whereBetween('price', ['1000', '8000'])
                ->orderBy('price', 'desc')->get();
        } else if ($userRole == '8000_9000') {
            $apartments = Apartment::with('amenities')
                ->whereBetween('price', ['1000', '9000'])
                ->orderBy('price', 'desc')->get();
        } else if ($userRole == '9000_10000') {
            $apartments = Apartment::with('amenities')
                ->whereBetween('price', ['1000', '10000'])
                ->orderBy('price', 'desc')->get();
        }

        return view('frontend.pages_frontend.apartments.index', compact('apartments'));

    }

    // search apartment

    public function search_apartment(Request $request)
    {

        // dd("search apartment");
        // $query = $request->input('query');
        // $apartments = Apartment::where('name', 'LIKE', "%$query%")
        //     //    ->orWhere('price', 'LIKE', "%$query%")
        //     ->whereBetween('price', [1000, 2000])
        //     ->orWhere('city', 'LIKE', "%$query%")
        //     ->get();

        // return (count($apartments));


        // // dd("search apartment");
        $query = $request->input('query');
        // display apartments based on user roles and pricing
        $userRole = auth::user()->getRoleNames()->first();
        $apartments = [];

        if ($userRole == 'Admin') {
            $apartments = Apartment::where('name', 'LIKE', "%$query%")
                ->orWhere('price', 'LIKE', "%$query%")
                ->orWhere('city', 'LIKE', "%$query%")
                ->get();

        } else if ($userRole == '1000_2000') {
            $apartments = Apartment::
                // ->where('name', 'LIKE', "%$query%")
                // ->whereBetween('price', ['1000', '2000'])
                // ->orWhere('city', 'LIKE', "%$query%")
                // ->get();
                // where('name', 'LIKE', "%$query%")
                //test scenarios for price btn : 1000-2000
                // whereBetween('price', [1000, 2000]) //works
                where(function ($query) {
                    $query->where('price', '>=', '1000')
                          ->where('price', '<=', '2000');
                })
                ->where('price', 'LIKE', "%$query%")
                ->get();

        } else if ($userRole == '2000_3000') {
            // $apartments = Apartment::with('amenities')
            //     ->where('name', 'LIKE', "%$query%")
            //     ->whereBetween('price', ['1000', '3000'])
            //     ->orWhere('city', 'LIKE', "%$query%")
            //     ->get();
            $apartments = Apartment::where(function ($query) {
                $query->where('price', '>=', '1000')
                      ->where('price', '<=', '3000');
            })
            ->where('price', 'LIKE', "%$query%")
            ->get();
        } else if ($userRole == '3000_4000') {
            $apartments = Apartment::where(function ($query) {
                $query->where('price', '>=', '1000')
                      ->where('price', '<=', '4000');
            })
            ->where('price', 'LIKE', "%$query%")
            ->get();
        } else if ($userRole == '4000_5000') {
            $apartments = Apartment::where(function ($query) {
                $query->where('price', '>=', '1000')
                      ->where('price', '<=', '5000');
            })
            ->where('price', 'LIKE', "%$query%")
            ->get();
        } else if ($userRole == '5000_6000') {
            $apartments = Apartment::where(function ($query) {
                $query->where('price', '>=', '1000')
                      ->where('price', '<=', '6000');
            })
            ->where('price', 'LIKE', "%$query%")
            ->get();
        } else if ($userRole == '6000_7000') {
            $apartments = Apartment::where(function ($query) {
                $query->where('price', '>=', '1000')
                      ->where('price', '<=', '7000');
            })
            ->where('price', 'LIKE', "%$query%")
            ->get();
        } else if ($userRole == '7000_8000') {
            $apartments = Apartment::where(function ($query) {
                $query->where('price', '>=', '1000')
                      ->where('price', '<=', '8000');
            })
            ->where('price', 'LIKE', "%$query%")
            ->get();
        } else if ($userRole == '8000_9000') {
            $apartments = Apartment::where(function ($query) {
                $query->where('price', '>=', '1000')
                      ->where('price', '<=', '9000');
            })
            ->where('price', 'LIKE', "%$query%")
            ->get();
        } else if ($userRole == '9000_10000') {
            $apartments = Apartment::where(function ($query) {
                $query->where('price', '>=', '1000')
                      ->where('price', '<=', '10000');
            })
            ->where('price', 'LIKE', "%$query%")
            ->get();
        }



        // add more conditions here


        return view('frontend.pages_frontend.apartments.search_apartments', compact('apartments'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $apartment = Apartment::find($id);
        // $apartment_proximities_data = !empty($apartment->apartment_proximities) ? json_decode($apartment->apartment_proximities, true): [];
        // $apartment_proximities_data_grouped = collect($apartment_proximities_data)->where('place_category','shopping_mall');
        // return($apartment_proximities_data_grouped);
        
        // dd($apartment);
        return view('frontend.pages_frontend.apartments.show', compact('apartment'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
