<?php

namespace App\Http\Controllers\BackEnd\Tours;

use App\Http\Controllers\Controller;
use App\Models\ApartmentProximity;
use App\Models\TourCategory;
use Illuminate\Http\Request;
use App\Models\Tour;
use App\Models\Itenary;
use App\Models\TourActivity;
use Illuminate\Support\Facades\File;





class TourController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $tour_categories = TourCategory::all();
        $tours = Tour::latest('created_at')->get();
        $count_tours = Tour::all()->count();
        $tour_activities = TourActivity::all();
        // $tour_itenaries = Itenary::all();

        // dd($tour_itenaries->toArray());
        return view('backend.pages_backend.tours.index', compact('tour_categories', 'tours', 'count_tours', 'tour_activities'));
    }


    // trashed posts
    public function trashed_tours()
    {
        $trashed_tours = Tour::onlyTrashed()->get();
        $count_trashed_tours = Tour::onlyTrashed()->count();
        // dd($count_trashed_tours);

        return view('backend.pages_backend.tours.trashed_tours', compact('trashed_tours', 'count_trashed_tours'));

    }

    // restore trashed tours
    public function restore_trashed_tours($id)
    {
        $restore_trashed_tour = Tour::where('id', $id)->withTrashed()->restore();
        return redirect('/admin/tours')->with('messagerestore', 'Tour Restored successfuly');


    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $tour_categories = TourCategory::all();
        // $amenities = Amenity::all();
        // dd($tour_categories);
        return view('backend.pages_backend.tours.create', compact('tour_categories'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


        // dd($request->all());
        $tour = new Tour();
        $tour->name = $request->name;
        $tour->description = $request->description;
        $tour->destination = $request->destination;
        $tour->start_date = $request->start_date;
        $tour->end_date = $request->end_date;
        $tour->tour_single_cost = $request->tour_single_cost;
        $tour->tour_couple_cost = $request->tour_couple_cost;

        $tour->tour_status = $request->tour_status;
        $tour->booking_status = $request->booking_status;
        $tour->slots_available = $request->slots_available;
        $tour->video_url = $request->video_url;
        $tour->created_by = auth()->user()->id;
        $tour->tour_category_id = $request->tour_category_id;
        // store tour itenaries
        foreach ($request->itenary_day_number as $key => $itenary) {
            if (!empty($itenary))
                $tour_itenaries[] = [
                    'itenary_day_number' => $itenary,
                    'itenary_time' => $request->itenary_time[$key],
                    'itenary_description' => $request->itenary_description[$key]
                ];
        }

        $tour->tour_itenaries = !empty($tour_itenaries) ? json_encode($tour_itenaries) : null;
        $tour->tour_includes = json_encode($request->tour_includes);
        $tour->tour_excludes = json_encode($request->tour_excludes);
        $tour->tour_activities = json_encode($request->tour_activities);


        // featured photo
        if ($request->hasfile('featured_photo')) {
            $file_featured = $request->file('featured_photo');
            $extension = $file_featured->getClientOriginalExtension();  //get image extension
            $filename_featured = time() . '.' . $extension;
            $file_featured->move('uploads/tour_featured_photos/', $filename_featured);
            $tour->featured_photo = url('uploads' . '/tour_featured_photos/' . $filename_featured);
        }


        // // multiple image library upload
        $files = [];
        if ($request->hasfile('photo_library')) {
            foreach ($request->file('photo_library') as $file_to_upload) {
                $filename = time() . rand(1, 50) . '.' . $file_to_upload->getClientOriginalExtension();
                $file_to_upload->move('uploads/tour_photos/', $filename);
                $files[] = url('uploads' . '/tour_photos/' . $filename);
            }
        }
        $tour->photo_library = implode(',', $files ?? []);

        // dd($tour->toArray());
        $tour->save();



        return redirect('/admin/tours')->with('messagesave', 'Tour added successfuly');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $tour_categories = TourCategory::all();
        $tour = Tour::find($id);
        $tour_activities = TourActivity::all()->where('tour_id', $tour->id);
        $tour_itenaries = Itenary::all()->where('tour_id', $tour->id);
        
        // $tour_itenaries_data = !empty($tour->tour_itenaries) ? json_decode($tour->tour_itenaries, true): [];
        // $tour_itenaries_data_grouped_by_day = collect($tour_itenaries_data)->groupBy('itenary_day_number');
        // return ( $tour_itenaries_data_grouped_by_day);


        // group data by day number 


        // dd($grouped_iteneraries_by_day->toArray());
        return view('backend.pages_backend.tours.edit', compact('tour_categories', 'tour', 'tour_activities', 'tour_itenaries'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // dd($request->itenary);
        $tour = Tour::find($id);
        $tour->name = $request->name;
        $tour->description = $request->description;
        $tour->destination = $request->destination;
        $tour->start_date = $request->start_date;
        $tour->end_date = $request->end_date;
        $tour->tour_single_cost = $request->tour_single_cost;
        $tour->tour_couple_cost = $request->tour_couple_cost;

        $tour->tour_status = $request->tour_status;
        $tour->booking_status = $request->booking_status;
        $tour->slots_available = $request->slots_available;
        $tour->video_url = $request->video_url;
        $tour->created_by = auth()->user()->id;
        $tour->tour_category_id = $request->tour_category_id;
        $tour->tour_includes = json_encode($request->tour_includes);
        $tour->tour_excludes = json_encode($request->tour_excludes);
        $tour->tour_activities = json_encode($request->tour_activities);

         // update tour itenaries
         foreach ($request->itenary_day_number as $key => $itenary) {
            if (!empty($itenary))
                $tour_itenaries[] = [
                    'itenary_day_number' => $itenary,
                    'itenary_time' => $request->itenary_time[$key],
                    'itenary_description' => $request->itenary_description[$key]
                ];
        }

        $tour->tour_itenaries = !empty($tour_itenaries) ? json_encode($tour_itenaries) : null;

        // featured photo
        if ($request->hasfile('featured_photo')) {
            $file_featured = $request->file('featured_photo');
            $extension = $file_featured->getClientOriginalExtension();  //get image extension
            $filename_featured = time() . '.' . $extension;
            $file_featured->move('uploads/tour_featured_photos/', $filename_featured);
            $tour->featured_photo = url('uploads' . '/tour_featured_photos/' . $filename_featured);
        }


        // // multiple image library upload
        // $files = [];
        // if ($request->hasfile('photo_library')) {
        //     foreach ($request->file('photo_library') as $file_to_upload) {
        //         $filename = time() . rand(1, 50) . '.' . $file_to_upload->getClientOriginalExtension();
        //         $file_to_upload->move('uploads/tour_photos/', $filename);
        //         $files[] = url('uploads' . '/tour_photos/' . $filename);
        //     }
        // }
        // $tour->photo_library = implode(',', $files ?? []);
        $files = [];

        // Check if there are new files to upload
        if ($request->hasfile('photo_library')) {
            foreach ($request->file('photo_library') as $file_to_upload) {
                $filename = time() . rand(1, 50) . '.' . $file_to_upload->getClientOriginalExtension();
                $file_to_upload->move('uploads/apartment_photos/', $filename);
                $files[] = url('uploads' . '/apartment_photos/' . $filename);
            }

            // Get the existing images from the database
            $existingFiles = explode(',', $tour->photo_library);

            // Merge the new files with the existing ones
            $files = array_merge($existingFiles, $files);

            // Update the photo_library field in the database
            $tour->photo_library = implode(',', $files);

        }

        // dd($tour->toArray());
        $tour->save();



        return redirect('/admin/tours')->with('messageupdate', 'Tour updated successfuly');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function delete_itenary($id)
    {
        dd("delete itenary");

        $itenary = Itenary::find($id);
        $itenary->delete();
        return redirect()->back()->with('messagedelete', 'Tour itenary deleted successfuly');

    }

    // delete tour image from multiple array
    public function delete_tour_image($id)
    {
        $tour = Tour::findOrFail($id);
        $image = request()->input('image');

        // Remove the image from the photo_library field
        $images = explode(',', $tour->photo_library);
        $images = array_filter($images, function ($img) use ($image) {
            return $img !== $image;
        });
        $tour->photo_library = implode(',', $images);
        $tour->save();

        // Delete the image file from storage
        if (File::exists(public_path($image))) {
            File::delete(public_path($image));
        }

        return response()->json(['success' => true]);
        // return redirect()->back();
    }

    public function destroy($id)
    {
        $tour = Tour::find($id);
        $tour->delete();
        return redirect('/admin/tours')->with('messagedelete', 'Tour Deleted successfuly');
    }
}
