<?php

namespace App\Http\Controllers\BackEnd\Reports;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Tenant;
use Auth;
use App\Models\VerificationReport;
use PDF;

class VerificationReportsReportsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $verification_reports = VerificationReport::all();
        $count_verification_reports = VerificationReport::all()->count();
        $tenants = Tenant::all();
        $verified_by_user = Auth::user()->name ;
        // dd($verification_reports);
        // updated by
        $created_by = Auth::user()->name ;
        $updated_by = Auth::user()->name ;


        return view('backend.pages_backend.reports.verification_reports.verification_reports_data',
        [

        'verification_reports' => $verification_reports ,
        'count_verification_reports' => $count_verification_reports,
        'updated_by' => $updated_by,
        'created_by' => $created_by,
        'tenants' => $tenants,
        'verified_by_user' => $verified_by_user,

    ]);
    }

    public function singleVerificationReportData (Request $request, $id){

        $verification_report =  VerificationReport::find($id);
        $created_by = Auth::user()->name ;
        $verified_by_user = Auth::user()->name ;

       //    report data array
           $data = [
             'tenant_name' => $verification_report->tenant_r->fullname,
             'imagePath'    => public_path('img/logo.png'),
             'date' => date('d/m/Y'),
             'created_by' => $created_by,
             'verified_by' => $verified_by_user,
             'work_they_do' => $verification_report->work_they_do,
             'location_of_incidence' => $verification_report->location_of_incidence,
             'reason_for_victim_challenge' => $verification_report->reason_for_victim_challenge,
             'perpetrator_name' => $verification_report->perpetrator_name,
             'threats_experienced' => $verification_report->threats_experienced,
             'reason_for_threats' => $verification_report->reason_for_threats,
             'organization_affiliated_to' => $verification_report->organization_affiliated_to,
             'is_organization_functional' => $verification_report->is_organization_functional,
             'police_report_status' => $verification_report->police_report_status,
             'police_report_reference_number' => $verification_report->police_report_reference_number,
             'reason_for_not_reporting_to_police' => $verification_report->reason_for_not_reporting_to_police,
             'support_needed_by_victim' => $verification_report->support_needed_by_victim,
             'outside_assistance_sought' => $verification_report->outside_assistance_sought,
             'security_plan' => $verification_report->security_plan,
             'details_of_threat' => $verification_report->details_of_threat,
             'date_of_threat' => $verification_report->date_of_threat,
             'place_of_threat' => $verification_report->place_of_threat,
             'recommendation' => $verification_report->recommendation,
             'sustainability_plan' => $verification_report->sustainability_plan,
             'property_taken_status' => $verification_report->property_taken_status,
             'referees_to_contact' => $verification_report->referees_to_contact,
             'prefered_area_of_relocation' => $verification_report->prefered_area_of_relocation,
             'total_verification_costs' => $verification_report->total_verification_costs,

            //  'shelter_format_name' => $shelter->shelter_format_r->shelter_format_name,


           //  'shelters' => $shelter
          ];

        $pdf = PDF::loadView('backend.pages_backend.reports.verification_reports.verification_reports_template', $data);
        // dd($pdf);
        return $pdf->stream($verification_report->tenant_r->fullname . ' Report.pdf');

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
