<?php

namespace App\Http\Controllers\BackEnd\Reports;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\EmergencyCase;
use Auth;
use App\Models\User;
use App\Models\Tenant;
use PDF;

class EmergencyCasesReportsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $emergency_cases = EmergencyCase::all();
        $count_emergency_cases = EmergencyCase::all()->count();
        $created_by = Auth::user()->name ;
        $tenants = Tenant::all();

        $users = User::all();
        return view('backend.pages_backend.reports.emergency_cases.emergency_cases_reports_data',
        [
         'emergency_cases' => $emergency_cases ,
        'count_emergency_cases' => $count_emergency_cases,
        'users' => $users,
        'created_by' =>  $created_by,
         'tenants'      => $tenants,

        ]);
    }

    // print report of each emergency case

    public function singleEmergencyCaseReportData(Request $request, $id)
     {

        $emergency_case =  EmergencyCase::find($id);

        // created by
        $created_by = Auth::user()->name ;

        //    report data array
            $data = [
              'imagePath'                                   => public_path('img/logo.png'),
              'date'                                        => date('d/m/Y'),
              'created_by'                                  => $created_by,
              'tenant_name'                                 => $emergency_case->tenant_r->fullname,
              'priority'                                    => $emergency_case->priority,
              'status'                                      => $emergency_case->status,
              'current_address'                             => $emergency_case->current_address,
              'email'                                       => $emergency_case->email,
              'phone_number'                                    => $emergency_case->phone_number,
              'organization_name_worked_with'               => $emergency_case->organization_name_worked_with,
              'organization_address_worked_with'            => $emergency_case->organization_address_worked_with,
              'organization_position'                       => $emergency_case->organization_position,
              'date_of_birth'                               => $emergency_case->date_of_birth,
              'gender'                                      => $emergency_case->gender,
              'person_name_to_contact_incase_of_emergency'  => $emergency_case->person_name_to_contact_incase_of_emergency,
              'person_email_to_contact_incase_of_emergency' => $emergency_case->person_email_to_contact_incase_of_emergency,
              'person_phone_to_contact_incase_of_emergency' => $emergency_case->person_phone_to_contact_incase_of_emergency,
              'activities_done'                             => $emergency_case->activities_done,
              'what_happened'                               => $emergency_case->what_happened,
              'when_it_happened'                            => $emergency_case->when_it_happened,
              'where_it_happened'                           => $emergency_case->where_it_happened,
              'why_it_happened'                             => $emergency_case->why_it_happened,
              'support_needed'                              => $emergency_case->support_needed,
              'what_can_we_do'                              => $emergency_case->what_can_we_do,
              'budget'                                      => $emergency_case->budget,
              'sustainability_plan'                         => $emergency_case->sustainability_plan,
              'secondary_person_name'                       => $emergency_case->secondary_person_name,
              'secondary_person_email'                      => $emergency_case->secondary_person_email,
              'secondary_person_phone'                      => $emergency_case->secondary_person_phone,
              'written_evidence'                            => $emergency_case->written_evidence,
              'any_other_information'                       => $emergency_case->any_other_information,
              'comment_on_case'                             => $emergency_case->comment_on_case,
            //   'photo_evidence_one'                          => public_path($emergency_case->photo_evidence_one),




            //   <a href="{!! asset($emergency_case->photo_evidence_one) !!}">
            //     <img onerror="if (this.src != '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}') this.src = '{{ asset('assets/backend_assets/assets/images/nodata/missing.png') }}';"
            //         src="{{ asset($emergency_case->photo_evidence_one) }}"
            //         alt="preview" style=" width:100% !important; object-fit:cover;">
            // </a>



           ];

         $pdf = PDF::loadView('backend.pages_backend.reports.emergency_cases.emergency_cases_report_template', $data);
         // dd($pdf);
         return $pdf->stream($emergency_case->tenant_r->fullname . ' Report.pdf');
     }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
