<?php

namespace App\Http\Controllers\BackEnd\Reports;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Acknowledgment;
use App\Models\Tenant;
use Auth;
use PDF;


class AcknowledgementsReportsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $acknowledgments = Acknowledgment::all();
        $count_acknowledgments = Acknowledgment::all()->count();
        $tenants = Tenant::all();
        return view('backend.pages_backend.reports.acknowledgments_reports.acknowledgments_reports_data',
        [
         'acknowledgments' => $acknowledgments ,
         'count_acknowledgments' => $count_acknowledgments,
         'tenants' => $tenants

     ]);
    }

    public function singleAcknowledgementReportData(Request $request, $id){
        $acknowledgment =  Acknowledgment::find($id);
        $acknowledged_by_user = Auth::user()->name ;
        $sign = $acknowledgment->recipient_signature;
        // dd($sign);
        //    report data array
            $data = [
              'tenant_fullname' => $acknowledgment->tenant_r->fullname,
              'imagePath'    => public_path('img/logo.png'),
              'date' => date('d/m/Y'),
              'payment_date' => $acknowledgment->payment_date,
              'address' => $acknowledgment->address,
              'amount_in_figures' => $acknowledgment->amount_in_figures,
              'amount_in_words' => $acknowledgment->amount_in_words,
              'payment_of' => $acknowledgment->payment_of,
              'paid_by' => $acknowledgment->paid_by,
              'payment_method' => $acknowledgment->payment_method,
              'acknowledged_by_user' => $acknowledged_by_user,
              'sign' =>  $sign,

            //   'signature' => public_path('uploads' . '/recipient_signatures/' . $acknowledgment->recipient_signature) ,


           ];

         $pdf = PDF::loadView('backend.pages_backend.reports.acknowledgments_reports.acknowledgments_reports_template', $data);
         // dd($pdf);
         return $pdf->stream($acknowledgment->tenant_r->fullname . ' Report.pdf');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
