<?php

namespace App\Http\Controllers\BackEnd\Apartments;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;

use App\Models\ApartmentProximity;
use Illuminate\Http\Request;
use App\Models\Apartment;
use App\Http\Requests\Apartments\StoreApartmentRequest;
use App\Http\Requests\Apartments\UpdateApartmentRequest;
use App\Models\ApartmentCategory;
use App\Models\Amenity;
use Illuminate\Support\Arr;

class ApartmentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // $apartments = Apartment::all();

        $apartments = Apartment::with('amenities', 'apartment_proximity')->latest('created_at')->get();
        $apartment_categories = ApartmentCategory::all();
        $amenities = Amenity::all();
        // $apart = Apartment::find(26);
        //  $apartment_proximities_data = !empty($apart->apartment_proximities) ? json_decode($apart->apartment_proximities, true): [];
        // $apartment_proximities_data_grouped = collect($apartment_proximities_data)->where('place_category','shopping_mall');
        // // return($apartment_proximities_data_grouped);

        $count_apartments = Apartment::all()->count();
        $restaurant_apartment_proximities = ApartmentProximity::where('place_category', 'restaurant')->get();

        // $apartment_amenties = Apartment::find($id);
        // return ($restaurant_apartment_proximities);

        return view('backend.pages_backend.apartments.index', compact('apartments', 'count_apartments', 'apartment_categories', 'amenities', 'restaurant_apartment_proximities'));


    }

    // trashed posts
    public function trashed_apartments()
    {
        $trashed_apartments = Apartment::onlyTrashed()->get();
        $count_trashed_apartments = Apartment::onlyTrashed()->count();
        // dd($count_trashed_apartments);

        return view('backend.pages_backend.apartments.trashed_apartments', compact('trashed_apartments', 'count_trashed_apartments'));

    }

    // restore trashed apartments
    public function restore_trashed_apartments($id)
    {
        $restore_trashed_apartment = Apartment::where('id', $id)->withTrashed()->restore();
        return redirect('/admin/apartments')->with('messagerestore', 'Apartment Restored successfuly');


    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $apartment_categories = ApartmentCategory::all();
        $amenities = Amenity::all();
        return view('backend.pages_backend.apartments.create', compact('apartment_categories', 'amenities'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreApartmentRequest $request)
    {
        $apartment = new Apartment();
        $apartment->name = $request->name;
        $apartment->address = $request->address;
        $apartment->city = $request->city;
        $apartment->beds = $request->beds;
        $apartment->size = $request->size;
        $apartment->description = $request->description;
        $apartment->rooms = $request->rooms;
        $apartment->bathrooms = $request->bathrooms;
        $apartment->property_status = $request->property_status;
        $apartment->property_booked_status = $request->property_booked_status;
        $apartment->balcony = $request->balcony;
        $apartment->property_video_url = $request->property_video_url;
        $apartment->price = $request->price;
        $apartment->google_map_iframe_url = $request->google_map_iframe_url;
        $apartment->price_range = $request->price_range;
        $apartment->apartment_category_id = $request->apartment_category_id;
        $apartment->units_available = $request->units_available;
        
        // store apartment proximities 
        foreach ($request->place_category as $key => $proximity) {
            if (!empty($proximity))
                $apartment_proximities[] = [
                    'place_category' => $proximity,
                    'place_name' => $request->place_name[$key],
                    'place_distance' => $request->place_distance[$key],
                    'place_time' => $request->place_time[$key],
                    'place_address' => $request->place_address[$key]
                ];
        }

        $apartment->apartment_proximities = !empty($apartment_proximities) ? json_encode($apartment_proximities) : null;

        // featured photo with caption

        // national_id_front_photo
        if ($request->hasfile('featured_photo')) {
            $file_featured = $request->file('featured_photo');
            $extension = $file_featured->getClientOriginalExtension();  //get image extension
            $filename_featured = time() . '.' . $extension;
            $file_featured->move('uploads/featured_photos/', $filename_featured);
            $apartment->featured_photo = url('uploads' . '/featured_photos/' . $filename_featured);
        }


        // photo library with caption
        // multiple image library upload
        $files = [];
        if ($request->hasfile('photo_library')) {
            foreach ($request->file('photo_library') as $file_to_upload) {
                $photo_library_photo_caption = $request->photo_library_photo_caption; // Get the caption for this photo
                $filename = time() . rand(1, 50) . '.' . $file_to_upload->getClientOriginalExtension();
                $file_to_upload->move('uploads/apartment_photos/', $filename);
                $files[] = url('uploads' . '/apartment_photos/' . $filename);
                //  $apartment->photo_library_photo_caption = $request->price_range;
            }
        }


        $apartment->photo_library = implode(',', $files ?? []);
        // dd($apartment->toArray());
        $apartment->save();

        // store proximity data to database and append apartment_id
        //   dd($request->proximity);
        // $rowDataProximity = [];
        // foreach ($request->proximity as $rowDataProximity) {
        //     $apartment_proximity = new ApartmentProximity();
        //     $apartment_proximity->apartment_id = $apartment->id;
        //     $apartment_proximity->place_category = $rowDataProximity['place_category'];
        //     $apartment_proximity->name = $rowDataProximity['name'];
        //     $apartment_proximity->distance = $rowDataProximity['distance'];
        //     $apartment_proximity->time = $rowDataProximity['time'];
        //     $apartment_proximity->address = $rowDataProximity['address'];
        //     $apartment_proximity->created_by = auth()->user()->id;
        //     // dd($apartment_proximity->toArray());
        //     $apartment_proximity->save();
        // }


        // Attach selected amenities to the apartment
        $apartment->amenities()->attach($request->input('amenities'));
        return redirect('/admin/apartments')->with('messagesave', 'Apartment added successfuly');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {



    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $apartment = Apartment::findOrFail($id);
        $count_apartments = Apartment::all()->count();
        $apartment_categories = ApartmentCategory::all();
        $amenities = Amenity::all();

        // dd($apartment);
        // $restaurant_apartment_proximities = ApartmentProximity::where('place_category', 'restaurant')->get();
        return view('backend.pages_backend.apartments.edit', compact('apartment', 'count_apartments', 'apartment_categories', 'amenities'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // dd("adfaf");
        $apartment = Apartment::find($id);
        $apartment->name = $request->name;
        $apartment->address = $request->address;
        $apartment->city = $request->city;
        $apartment->beds = $request->beds;
        $apartment->size = $request->size;
        $apartment->description = $request->description;
        $apartment->rooms = $request->rooms;
        $apartment->bathrooms = $request->bathrooms;
        $apartment->property_status = $request->property_status;
        $apartment->property_booked_status = $request->property_booked_status;
        $apartment->balcony = $request->balcony;
        $apartment->property_video_url = $request->property_video_url;
        $apartment->price = $request->price;
        $apartment->google_map_iframe_url = $request->google_map_iframe_url;
        $apartment->price_range = $request->price_range;
        $apartment->units_available = $request->units_available;
        $apartment->apartment_category_id = $request->apartment_category_id;
        // update apartment proximities 
        foreach ($request->place_category as $key => $proximity) {
            if (!empty($proximity))
                $apartment_proximities[] = [
                    'place_category' => $proximity,
                    'place_name' => $request->place_name[$key],
                    'place_distance' => $request->place_distance[$key],
                    'place_time' => $request->place_time[$key],
                    'place_address' => $request->place_address[$key]
                ];
        }

        $apartment->apartment_proximities = !empty($apartment_proximities) ? json_encode($apartment_proximities) : null;

        // featured photo with caption

        // national_id_front_photo
        if ($request->hasfile('featured_photo')) {
            $file_featured = $request->file('featured_photo');
            $extension = $file_featured->getClientOriginalExtension();  //get image extension
            $filename_featured = time() . '.' . $extension;
            $file_featured->move('uploads/featured_photos/', $filename_featured);
            $apartment->featured_photo = url('uploads' . '/featured_photos/' . $filename_featured);
        }


        $files = [];

        // Check if there are new files to upload
        if ($request->hasfile('photo_library')) {
            foreach ($request->file('photo_library') as $file_to_upload) {
                $filename = time() . rand(1, 50) . '.' . $file_to_upload->getClientOriginalExtension();
                $file_to_upload->move('uploads/apartment_photos/', $filename);
                $files[] = url('uploads' . '/apartment_photos/' . $filename);
            }

            // Get the existing images from the database
            $existingFiles = explode(',', $apartment->photo_library);

            // Merge the new files with the existing ones
            $files = array_merge($existingFiles, $files);

            // Update the photo_library field in the database
            $apartment->photo_library = implode(',', $files);

        }

        // dd($apartment);
        $apartment->save();

        // Attach selected amenities to the apartment
        // $apartment->amenities()->attach($request->input('amenities'));
        $apartment->amenities()->sync($request->input('amenities'));

        return redirect('/admin/apartments')->with('messagesave', 'Apartment added successfuly');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    public function delete_apartment_image($id)
    {
        $apartment = Apartment::findOrFail($id);
        $image = request()->input('image');

        // Remove the image from the photo_library field
        $images = explode(',', $apartment->photo_library);
        $images = array_filter($images, function ($img) use ($image) {
            return $img !== $image;
        });
        $apartment->photo_library = implode(',', $images);
        $apartment->save();

        // Delete the image file from storage
        if (File::exists(public_path($image))) {
            File::delete(public_path($image));
        }

        return response()->json(['success' => true]);
        // return redirect()->back();
    }
    public function destroy($id)
    {
        $apartment = Apartment::find($id);
        $apartment->delete();
        return redirect('/admin/apartments')->with('messagedelete', 'Apartment Deleted successfuly');
    }
}
