<?php

namespace App\Http\Controllers\Api\v1\Districts;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\District;


class DistrictsApiController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {


       if(District::count() > 0){
        $districts = District::all();
        $count_districts = District::count();

        // return
        return [
            "status" => "Success",
            "Number of Districts" =>   $count_districts,
            "message" => "Districts Retrieved successfully",
            "data" => $districts
        ];
    }

    // if no record
    else {
        //response
        return [
            "status" => "Error",
            "message" => "Oops!, No Districts Found in Database ",

        ];

    }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
         //  validate data fields

         $validatedData = $request->validate([
            'district_name' => 'required',


        ]);

        $district = new District();
        $district->district_name = $request->district_name;

        // save district
        $district->save();


        // response
        return [
            "status" => "Success",
            "message" => "District Added successfully",
            "data" => $district
        ];
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        // find Customer id
       if(District::where("id", $id)->exists()){
        $district = District::find($id);

        // return response
        return [
            "status" => 200,
            "message" => "District Retrieved successfully",
            "data" =>$district
        ];
    }

     // if no record
     else {

        return [
            "status" => 404,
            "message" => "Oops!, District Not Found ",

        ];

    }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        if(District::where("id", $id)->exists()){
            $district   = District::find($id);
            $district->district_name = !empty($request->district_name)? $request->district_name: $district->district_name;

            // save Customer
            $district->save();

            // response for success
            return [
                "status" => 200,
                "message" => "District updated successfully",
                "data" => $district

            ];
        }
        // if no record by id found
        else {

            // response for success
            return [
                "status" => 404,
                "message" => "Oops!,  District Not Found to update ",

            ];

        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         // find id
         if(District::where("id", $id)->exists()){
            $district = District::find($id);
            $district->delete();
            // response for success
            return [
                "status" => 200,
                "message" => "District Deleted successfully",
                "data" => $district,
            ];
        }

        // if no record
        else {
            // response for success
            return [
                "status" => 404,
                "message" => "Oops!, No District Found to Delete "
            ];

        }
    }


}
